#  SpiceFly - SugarCube - Copyright 2008 Charles Parker
#
#  Developed by Charles Parker - http://www.spicefly.com/
#  Based on framework and plugin; NowPlaying.pm by Max Spicer ( http://www.thespicers.net/slim.html#nowPlaying)
#
#  What SugarCube does
#    SugarCube achieves my desire for SqueezeCentre and MusicIP to just get on with playing music.
#     Once installed, just play a track,  this will then become the seed track and your journey begins through your music library.
#      Using this seed, SugarCube asks MusicIP for a selection and then chooses one and queues it up to play.
#      Once the first track ends, the second track is now your seed track and so on and so on! 
#       Therefore you are taken on a journey through your music library without all the hassle of playlists
#      or lots of key pressing, you never experience the same list ever or reach the end!  
#
#   Version 0.5 - Internal Release ;)
#  Added Filter check before sending to MusicIP 
#
#   Version 1.0 - Released 25th June 2008
#   First Public Release
#
#   Version 1.1 - Released 25th June 2008
#   Optimised code for SC Injection of new track, removing the need for the Web API CAUTH  - Michael (mherger)
#
#   Version 1.2 - Released 26th June 2008
#   Depreciated port name and numbers for MIP and SC, SC no longer required as we inject via different methods, 
#    MIP port is read from MIP settings as we assume that MIP is running on the same machine as SC
#   MIP Settings are used for the Variety, Filter and Style settings.  Plugin is now hands free requiring no configuration.
#   MIP Settings are read dynamically before selecting the next track, so changes are pretty immediate.
#   Enable/Disable via Extra Menu - Always starts up disabled by default
#   Plugin version SC 7.2 enabled as it appears to work ok
#   
#   Version 1.2.1 - Released 26th June 2008
#   Fixed typo errors which broke the path correction formatting for MIP 
#  
#  Version 1.2.2 - Released 27th June 2008
#   Added failback state for when we dont find any port, variety, filter or style settings.
#
#  Version 1.2.3 - Released 28th June 2008
#  Added Linux/Unix check and path fix before MIP query
#
#  Version 1.3
#  Skip bad luck release ;)
#
#  Version 1.4 - 7th July 2008
#  = Some removal and tidy up of code, removal of some unrequired scalars.
#  = Functions split to make it easier to maintain and develop.
#  + Added first effort at stopping repeat tracks, will now try 4 times to select a track not played before, after this time it allows the track to be added
#      does not go back to MIP as this may have potential to cause some performance issues hitting MIP quickly for requests?
#  + Added Web interface to enable settings and enable/disable via web page
#  + Added support for MIP Mix Recipes (A SqueezeCentre first =)   (Moods are not available yet via MIP Headless as of MIP1.9b5)
#  + Added Schedule filter, ie. alternative MIP filter so that can vary tracks, for example more dance during day and start sending more chilled out in evening
#  - Removed Playlist culling as adding tracks and removing tracks quickly causes SC to fire newsong notifications even though its not a newsong :s  function to be revisted
#  - Removed dependency on MIP settings, use our own to reduce complexity
#
#   Version 1.4.1 - 8th July 2008
#   +  Added routine to enable track selection from top of results, in some situations MIP may put greater bias on the first result as better matching the original seed track (says MusicIP =)
#       this is a try it and see if you prefer it option :)
#  = Fixed error with padding of filter times in web settings page
#  +  Added purge routine, to wipe tracking array after playing 30 tracks ( will require improvement e.g sliding array dropping tracks from start of array)
#  +  Added ' replacement before submitting to MIP - caused the notify error nemesis
#  = Fixed '&' replacement before submitting to MIP, was only replacing the first '&' it found in the dir/filename rather than all of them!  - caused the notify error nemesis
#  = Fixed debugging output that was not using the debug routine, should be quiet now assuming not running in debug mode
#
#  Version 1.4.2 - 9th July 2008
#  +  Added sliding tracking array, user-definable for how many tracks to remember before allowing a repeat
# +   Added routine to protect against the situation when track "select from top" is active and selected track has already been played, will now pick randomly from MIP results
#      to try and work its way out of the hole.
#  =  Few tweaks and tidy up of the code
#
#  Version 1.4.3 - 10th July 2008
#  +  Improved the power up function should enable correctly (if applicable) on startup
#  +  Added fixes for the following characters in track names   +  ,  [  ]  before submitting to MIP
#  +  Added fixes for the following characters in track names        before submitting to MIP
#  =  Fixed SugarCube would disable if playing was stopped
#  +  Added setting to enable forgetting, so if playlist is cleared - clear our previous played tracking array
#  +  Added simple function to breakout mirroring of first track when using select from top, we bounce it to force a random selection from the results. 
#
#  Version 1.4.4 - 20th July 2008
#  = Fixed Enable/Disable routine so it works with the Squeezebox Duet, configuration still via web page (for now)
#  +  Added Dropdown filter lists in the web configuration page, poached from the MIP plugin (thanks guys)
#
#  Version 1.5 - 9th Sept 2008
#  + Added volume fade option, to gradually step down the volume each track change, perfect as a nightime aid for sleeping  ;)
# + Added Player Sleep functionality, to shutoff the player after a specified time
#  This now allows a single track selection to kickoff MIP mixing with automatic volume fading and player sleep
# + Change of code for encoding track before sending to MIP, this is hopefully the proper coding and escaping method
# + Because of change above, rewrite of tracking array which should fix the first selection matching the first track issue
# + Added code to protect against multiple notifications when players are synced
# + Improved filter selection, can now specify different MIP filters each hour 
# = Tidy up of scalars
#
# Version 1.5.1 - 16th Sept 2008
# = Removal of Linux/Unix fudge workaround which is no longer required (Thanks Erland)
#
# Version 1.6 - 10th October 2008
# + SugarCube now has Dynamic Playlist integration, thanks to Erland for this.
# + Big overhaul of the code to improve efficency, again a big thanks to Erland for his fine work.
# = Fixed volume flag issue where the wrong flag was checked.
# + Added Shuffle Terminator  to ensure that shuffle song/album is not active when SugarCube is mixing
# + Added Playlist Culling function, keeps the list small and tidy now
#
# Version 1.6.1 - 12th October 2008
# = Change to Sync function to make it work with 7.3, this protects against multiple notifications when players are synced
#
# Version 1.7 - 20th October 2008
# + New routines to finally fix foreign character support
# + Clean up and restructure of some functions to improve maintainability
# = Current Issue with Dynamic Playlist to be fixed shortly
#
# Version 1.7.1 - 21st October 2008
# = Minor clean up of the code
# 
# Version 1.8.0 - 3rd January 2009
#  Major rewrite of functions and improvements to make SugarCube play nicer with SqueezeCenter
# + Changed tracking array method to incorporate entire path and track
# + Added checks to ensure current playing track is not stored multiple times in the tracking array
# + Major Engine Replacement of tracking and checking routines, big improvement in reducing track duplication when playing.
# = Removed old routines not required anymore
#  + Rewrite of menu code, to input.choice which reduces loading on SqueezeCenter
#  + Added Volume Fade and Player Sleep Enable/Disable functionality into the menu system 
#  + Rewrite of MusicIP Calls to Async Code; which reduces loading on SqueezeCenter
#
#  Version 1.8.1 - 8th January 2009
# = Alteration to unique track routine to make it case insensitive, MIP helpfully will on occasion return tracks ignoring case 
#
# Version 1.8.2 - 9th January 2009
# + Switch from Async call to Sync call to enable integration back into Dynamic Playlist
# = Restructuring of procedures to enable integration back into Dynamic Playlist
#
#
#
#  To Do List; 
#        His n Her functions so multiple users can have different filter and selection criteria
#       Support user-defined recipes
#       Jive Menus
#
# Known Errors;
#  If you have a small music collection or a tight selection criteria on the filter then you may get duplication of tracks.
#  Current Issue with Dynamic Playlist to be fixed shortly
#
#  Pre-Reqs
#   MusicIP running in headless mode or running  with the GUI permanently open with API enabled
#
#   Installation Details;
#  1)  Copy folder into your plugin folder e.g.C:\program Files\SqueezeCenter\server\Plugins\SugarCube
#  2)  Shutdown and restart SqueezeCentre to load the plugin
#  3)  Once SqueezeCentre is up, navigate to the Plugin Settings page and configure SugarCube
#  4)  Once configured SugarCube can be enabled/disabled via the Extra Menu
#  5)  Sit back and enjoy your collection.
#  6)  Note to go back to normal playing mode, you need to go to the Extra menu to disable SugarCube
#
# This code is derived from code with the following copyright message:
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

package Plugins::SugarCube::Plugin;
use base qw(Slim::Plugin::Base);
use strict;
use Slim::Utils::Misc;
use Slim::Utils::Prefs;
use Slim::Utils::Log;

use Slim::Utils::Strings qw(string);
use Slim::Control::Request;
use Slim::Utils::OSDetect;
use Plugins::SugarCube::Settings;
use Scalar::Util qw(blessed);
use DBI qw(:sql_types);
use Slim::Utils::Timers;
###############################################################################
my $mystyle;
my $myvariety;
my @newtrackarray=();
my $myfilter;
my $mymipport;
my %menuSelection;
my $line;
my $sugarcube_flag;		# Whether on or off
my $sugarmip_flag;		# Take from top of MIP array
my $sugarport;
my $sugarstyle;
my $sugarvariety;
my $recipe;
my $sugarrecipe;		# Track whether to use recipe
my $prefs = preferences('plugin.SugarCube');
my $sugarslide;			# Sliding array size
my $sugarcleartracks;	# Forget Flag 
my $sugarcubevolume_flag; # Yes slide volume
my $sugarcubevolumetime;   # Time to slide volume
my $sugarcubevolume;		# Slide volume by
my $sugarcubevolumetimeend;  # End time to slide volume
my $sugarcubesleep_flag;
my $scsleepfrom;
my $scsleepto;
my $scsleepduration;
my $sleepgov;				# Save state have we activated a sleep already

########### Dynamic Playlist integration start ##############
my %lastDynamicPlaylistTrack = ();
my %dynamicPlaylistActive = ();
########### Dynamic Playlist integration end ##############
#
#
# List of items to display
my @lines = ('PLUGIN_SUGARCUBE_FLAG_ON',## These are enable disable functions for sugarcube
	'PLUGIN_SUGARCUBE_FLAG_OFF');

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.sugarcube',
	'defaultLevel' => 'DEBUG',
	'description'  => getDisplayName(),
});

sub initPlugin {
	my $class = shift;
	my $client = shift;
	$class->SUPER::initPlugin();
	$sleepgov = '0';
	
	Plugins::SugarCube::Settings->new;
	
	if ($prefs->get('sugarcube_flag') eq '') {				# Setup defaults if not set
		$prefs->set('sugarcube_flag', "0");
	}
	$sugarcube_flag = $prefs->get('sugarcube_flag');
	
	if ($prefs->get('sugarmip_flag') eq '') {	
		$prefs->set('sugarmip_flag', "0");
	}
	$sugarmip_flag = $prefs->get('sugarmip_flag');

	if ($prefs->get('sugarport') eq '') {	
		$prefs->set('sugarport', "10002");
	}
	$sugarport = $prefs->get('sugarport');
	
	if ($prefs->get('sugarstyle') eq '') {	
		$prefs->set('sugarstyle', "60");
	}
	$sugarstyle = $prefs->get('sugarstyle');

	if ($prefs->get('sugarvariety') eq '') {	
		$prefs->set('sugarvariety', "2");
	}
	$sugarvariety = $prefs->get('sugarvariety');

	if ($prefs->get('recipe') eq '') {	
		$prefs->set('recipe', "0");
	}
	$recipe = $prefs->get('recipe');

	for(my $hour=0;$hour<24;$hour++) {
		my $postfix = $hour;
		if($hour<10) {
			$postfix = '0'.$postfix;
		}
		if (!$prefs->get('sugarfilter'.$postfix)) {	
			$prefs->set('sugarfilter'.$postfix, "0");
		}
	}
	
	if ($prefs->get('sugarslide') eq '') {	
		$prefs->set('sugarslide', "30");
	}
	$sugarslide = $prefs->get('sugarslide');
	
	if ($prefs->get('sugarcleartracks') eq '') {	
		$prefs->set('sugarcleartracks', "1");
	}
	$sugarcleartracks = $prefs->get('sugarcleartracks');
	
	if ($prefs->get('sugarcubevolume_flag') eq '') {	
		$prefs->set('sugarcubevolume_flag', "0");
	}
	$sugarcubevolume_flag = $prefs->get('sugarcubevolume_flag');
	
	if ($prefs->get('sugarcubevolumetime') eq '') {	
		$prefs->set('sugarcubevolumetime', "23");
	}
	$sugarcubevolumetime = $prefs->get('sugarcubevolumetime');
	
	if ($prefs->get('sugarcubevolumetimeend') eq '') {	
		$prefs->set('sugarcubevolumetimeend', "07");
	}
	$sugarcubevolumetimeend = $prefs->get('sugarcubevolumetimeend');
	
	if ($prefs->get('sugarcubevolume') eq '') {	
		$prefs->set('sugarcubevolume', "1");
	}
	$sugarcubevolume = $prefs->get('sugarcubevolume');
	
	if ($prefs->get('sugarcubesleep_flag') eq '') {	
		$prefs->set('sugarcubesleep_flag', "0");
	}
	$sugarcubesleep_flag = $prefs->get('sugarcubesleep_flag');
	
	if ($prefs->get('scsleepfrom') eq '') {	
		$prefs->set('scsleepfrom', "0");
	}
	$scsleepfrom = $prefs->get('scsleepfrom');
	
	if ($prefs->get('scsleepto') eq '') {	
		$prefs->set('scsleepto', "0");
	}
	$scsleepto = $prefs->get('scsleepto');
	
	if ($prefs->get('scsleepduration') eq '') {	
		$prefs->set('scsleepduration', "0");
	}
	$scsleepduration = $prefs->get('scsleepduration');
	
	# Listen out for commands
	$log->debug('SugarCube: Setting execute callback');
	Slim::Control::Request::subscribe(\&commandCallback, [['stop', 'power', 'playlist']]);
	
 my @menu = (
              {
                      # localize text where possible
                      text    =>  Slim::Utils::Strings::string('PLUGIN_SUGARCUBE'),
                      id      => 'pluginFoobarTweakSomething',
                      weight  => 10,
                      actions => {
                              go => {
                                      player => 0,
                                      cmd    => [ 'whatever', 'someArgument' ],
                                      params => {
                                              state => 'tweaked',
                                      },
                              }
                      },
              },
              {
                      # localize text where possible
                      text    => Slim::Utils::Strings::string('PLUGIN_SUGARCUBE_NAME'),
                      id      => 'pluginFoobarActivateSomething',
                      weight  => 20,
                      actions => {
                              go => {
                                      player => 0,
                                      cmd    => [ 'whatever', 'someOtherArgument' ], 
                                      params => {
                                              activate => '1',
                                      },
                              }
                      },
              },);
              Slim::Control::Jive::registerPluginMenu(\@menu, 'settings');

}
sub whatever {
$log->debug("At whatever\n");

 }
sub shutdownPlugin {
	Slim::Control::Request::unsubscribe(\&commandCallback);
}

sub setMode {
	my $class  = shift;
	my $client = shift;
	my $method = shift || '';
	# Handle request to exit our mode.
	if ( $method eq 'pop' ) {
	Slim::Buttons::Common::popMode($client);
		return;
	}
	$log->debug("Flag Options; $sugarcube_flag Sleep;$sugarcubesleep_flag Volume;$sugarcubevolume_flag\n");
	
	my @topMenuItems = ();

	if ( $sugarcube_flag == 0 ) {		# If we are disabled add ON option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_FLAG_ON}';
	}
	if ( $sugarcube_flag == 1) {		# If we are disabled add OFF option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_FLAG_OFF}';
	}
	if ( $sugarcubesleep_flag == 1) {		# Sleep ON add OFF option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_SLEEP_OFF}';
	}
	if ( $sugarcubesleep_flag == 0) {		# Sleep OFF add ON option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_SLEEP_ON}';
	}	
	if ( $sugarcubevolume_flag == 1) {		# Volume ON add OFF option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_VOLUME_FADE_OFF}';
	}
	if ( $sugarcubevolume_flag == 0) {		# Volume OFF add ON option
		push @topMenuItems, '{PLUGIN_SUGARCUBE_VOLUME_FADE_ON}';
	}	
	
	my %params = (
		header => '{PLUGIN_SUGARCUBE} {count}',
		listRef => \@topMenuItems,
		modeName => 'MYSUGARCUBE',
		onRight => sub {
			my ( $client, $item ) = @_;
			enterCategoryItem( $client, $item );
		},
		overlayRef => sub {
			my $client = shift;
			return [ undef, $client->symbols('rightarrow') ];
		},
	);
	if ( $method eq 'push' ) {
		Slim::Buttons::Common::pushModeLeft($client,'INPUT.Choice', \%params );
	} else {
		Slim::Buttons::Common::pushMode($client,'INPUT.Choice',\%params );
		$client->update();
	}
}
sub getDisplayText {
	my ($client, $item) = @_;
	my $name = '';
	if($item) {
		$name = $item->{'name'};
	}
	return $name;
}
sub getOverlay {
		my ($client, $item) = @_;
	if(defined($item->{'playlist'}->{'parameters'})) {
			return [$client->symbols('rightarrow'), $client->symbols('notesymbol')];
		} else {
			return [undef, $client->symbols('notesymbol')];
		}
	if(defined($item->{'playlist'}->{'parameters'})) {
		return [$client->symbols('rightarrow'), undef];
	}
	return [undef, undef];
}
sub getFunctions {
	return {};
}
sub getDisplayName {
	return 'PLUGIN_SUGARCUBE_ON';
}
sub enterCategoryItem($$) {
	    my $client = shift;
	    my $item   = shift;
		$log->debug("At enterCategoryItem;$client $item\n");
	    # Dispatch to the correct method.
	    if ($item eq '{PLUGIN_SUGARCUBE_FLAG_OFF}' ) {	#ok
	        ToggleSugarCubeOnOff($client, $item );
	    } elsif ($item eq '{PLUGIN_SUGARCUBE_FLAG_ON}' ) {	#ok
	        ToggleSugarCubeOnOff($client, $item );			
	    } elsif ( $item eq '{PLUGIN_SUGARCUBE_VOLUME_FADE_ON}' ) { #ok
	        ToggleVolume( $client, $item );
	    } elsif ( $item eq '{PLUGIN_SUGARCUBE_VOLUME_FADE_OFF}' ) { #ok
	        ToggleVolume( $client, $item );
	    } elsif ( $item eq '{PLUGIN_SUGARCUBE_SLEEP_ON}' ) { #ok
	        ToggleSleep( $client, $item );
	    } elsif ( $item eq '{PLUGIN_SUGARCUBE_SLEEP_OFF}' ) { #ok
	        ToggleSleep( $client, $item );
	    }
}
sub ToggleSugarCubeOnOff {			# Called from Menu - Turn SugarCube On or Off
my ($client, $item) = @_;
if ($sugarcube_flag == '1') 
	{ $sugarcube_flag = '0';
	$prefs->set('sugarcube_flag', "$sugarcube_flag");
	$line = $client->string('PLUGIN_SUGARCUBE_OFF');
} else {
	$sugarcube_flag = '1';
	$prefs->set('sugarcube_flag', "$sugarcube_flag");
	$line = $client->string('PLUGIN_SUGARCUBEON_MENU_ENABLE');
	}
$log->debug("Flag;$sugarcube_flag");	
$client->showBriefly({'line1' =>  $client->string('PLUGIN_SUGARCUBE'), 'line2' => $line},{ 'duration' => 5, 'block' => 0 } );
return;
}
sub ToggleVolume {			# Called from Menu - Turn SugarCube Volume Fade On or Off
my ($client, $item) = @_;
if ($sugarcubevolume_flag == '1') 
	{ $sugarcubevolume_flag = '0';
	$prefs->set('sugarcubevolume_flag', "$sugarcubevolume_flag");
	$line = $client->string('PLUGIN_SUGARCUBE_MENU_VOL_DISABLED');
} else {
	$sugarcubevolume_flag = '1';
	$prefs->set('sugarcubevolume_flag', "$sugarcubevolume_flag");
	$line = $client->string('PLUGIN_SUGARCUBE_MENU_VOL_ENABLE');
	}
$log->debug("VolumeFlag;$sugarcubevolume_flag");
$client->showBriefly({'line1' =>  $client->string('PLUGIN_SUGARCUBE'), 'line2' => $line},{ 'duration' => 5, 'block' => 0 } );
return;
}
sub ToggleSleep {			# Called from Menu - Turn SugarCube Sleep On or Off
my ($client, $item) = @_;
if ($sugarcubesleep_flag == '1') 
	{ $sugarcubesleep_flag = '0';
	$prefs->set('sugarcubesleep_flag', "$sugarcubesleep_flag");
	$line = $client->string('PLUGIN_SUGARCUBE_MENU_SLEEP_DISABLED');
} else {
	$sugarcubesleep_flag = '1';
	$prefs->set('sugarcubesleep_flag', "$sugarcubesleep_flag");
	$line = $client->string('PLUGIN_SUGARCUBE_MENU_SLEEP_ENABLE');
	}
$log->debug("SleepFlag;$sugarcubesleep_flag");
$client->showBriefly({'line1' =>  $client->string('PLUGIN_SUGARCUBE'), 'line2' => $line},{ 'duration' => 5, 'block' => 0 } );
return;
}
sub commandCallback {
	my $request = shift;
	my $client = $request->client();
	$log->debug("\n#######################\n");
	$log->debug('SugarCube: received command: ' . $request->getRequestString());
	
	if ($request->source && ($request->source eq 'PLUGIN_SUGARCUBE')) {
		$log->debug("SugarCube: Received Own Noise, Ignoring");
		return;
	}
	
	if ($request->isCommand([['power']])) {
		$log->debug('SugarCube: received POWER; REFRESH SETTINGS');
		refreshCube();		# Load Up Preferences
		return;
	}
	if ($request->isCommand([['playlist'], ['clear']])) {
				$log->debug('SugarCube: CLEAR');
				if ($sugarcleartracks == '1') {			# Should forget our memory
					$#newtrackarray = -1; 
					my $e=@newtrackarray;	
					$log->debug("\nNewtrackarraySize: $e\n");
				}
				}
	if ($request->isCommand([['stop']])	|| $request->isCommand([['power']]) && !$client->power()) {
				$log->debug('SugarCube: setting now playing to nothing');
			}
	########### Dynamic Playlist integration start ##############
	if ($request->isCommand([['playlist'], ['newsong']]) && isDynamicPlaylistActive($client)) {
		$log->debug("SugarCube: newsong cmd recevied with active Dynamic Playlist");														
															# Turn Volume Down if Activated
	if ($sugarcubevolume_flag == '1') {slideVolume($client);}
	playlistcull($client);					# Routine to cull playlist
	sleepplayer($client);					# Check whether to sleep player or not
		return;
	########### Dynamic Playlist integration end ##############
	}
	if($sugarcube_flag == '0') {
			$log->debug("Relax SugarCube DISABLED");
			return;
	} elsif ($sugarcube_flag == '1') {
		# If in shuffle mode, we need to turn it off
		if (Slim::Player::Playlist::shuffle($client) == 1 || Slim::Player::Playlist::shuffle($client) == 2) {
			$client->execute(["playlist", "shuffle", 0]);
			$log->debug("Turned Shuffle OFF\n");	}
	
		if ($request->isCommand([['playlist'], ['newsong']])) {
					if (Slim::Player::Sync::isSlave($client)) {
					$log->debug(sprintf("Ignoring new song notification for slave player"));
					return;
				} else {
				$log->debug("New song detected\n");
				my $mytitle = SaveMyCurrentTrack($client);				#  Strip and Store played track Latin1 format
				my $element = getMIPPath($client, $mytitle);
				refreshCube();		# Check settings
				my $mypageurl = buildMIPReq($client, $mytitle);			# Routine to get MIP settings and build MIP request
				my $track = SendtoMIPSync($client,$mypageurl);
				addtrack($client, $track);							# Add Track
	
	my $bigtrack=@newtrackarray;					
	if ($bigtrack > $sugarslide) 						# After playing x tracks, wipe first element of the Tracking Array of our played tracks
	{shift(@newtrackarray);}
														# Turn Volume Down if Activated
	if ($sugarcubevolume_flag == '1') {slideVolume($client);}
	
	playlistcull($client);					# Routine to cull playlist
	sleepplayer($client);					# Check whether to sleep player or not
				
				$log->debug("\n#######################\n");	}
			}
	}			#If we are alive.. stops here 
}
sub SaveMyCurrentTrack {
	my $client = shift;
	my $song = shift;
	my $dumpindex;
	# Get details of current track
	if(!defined($song)) {
		$song = Slim::Player::Playlist::url($client);
	}
    my $mytitle = Slim::Utils::Unicode::utf8on(Slim::Utils::Misc::pathFromFileURL($song));	

	if ( grep { $_ eq $mytitle} @newtrackarray ) {
		$log->debug("\nPlaying Track Already in Array!\n '$mytitle'\n\n");
    } else {
		push (@newtrackarray, $mytitle);		# Add track to array - current playing track to stop next selection matching	
		$log->debug("\n####\nPushed to NewTrackArray Current Playing Track; $mytitle\n####\n");
	}
	$log->debug("\nNewtrackarray;\n");
	for($dumpindex=0; $dumpindex<$#newtrackarray+1; $dumpindex++) {$log->debug("$newtrackarray[$dumpindex]\n");}
	return $mytitle;
}

sub getMIPPath {
	my $client = shift;
	my $path = shift;
	my $myos  = Slim::Utils::OSDetect::OS();				# Work out what OS we are
	if ($myos eq 'win' || $myos eq 'mac') {
		$path = URI::Escape::uri_escape($path);
	} else {
		$path = Slim::Utils::Misc::escape($path);
	}	
	$path = Slim::Utils::Unicode::utf8encode_locale($path); 	
	$path =~ s{file:////}{//};							# Clean up all this file: malarky
	$path =~ s{file:///}{};							# Clean up all this file: malarky 	
	return $path;
}
sub getDisplayName {
	return 'PLUGIN_SUGARCUBE';
}
sub refreshCube {
	$log->debug("Settings Refreshing!");
	$sugarcube_flag = $prefs->get('sugarcube_flag');
	$sugarmip_flag = $prefs->get('sugarmip_flag');
	$sugarport = $prefs->get('sugarport');
	$sugarstyle = $prefs->get('sugarstyle');
	$sugarvariety = $prefs->get('sugarvariety');
	$recipe = $prefs->get('recipe');
	$sugarslide = $prefs->get('sugarslide');
	$sugarcleartracks = $prefs->get('sugarcleartracks');
	$sugarcubevolume_flag = $prefs->get('sugarcubevolume_flag');
	$sugarcubevolumetime = $prefs->get('sugarcubevolumetime');
	$sugarcubevolume = $prefs->get('sugarcubevolume');
	$sugarcubevolumetimeend = $prefs->get('sugarcubevolumetimeend');
	$scsleepduration = $prefs->get('scsleepduration');
	$sugarcubesleep_flag = $prefs->get('sugarcubesleep_flag');
	$scsleepfrom = $prefs->get('scsleepfrom');
	$scsleepto = $prefs->get('scsleepto');

	# SugarCube settings
	$mymipport = $sugarport;
	$mystyle = $sugarstyle;
	$myvariety = $sugarvariety;

	if ($recipe == 1) {
		$sugarrecipe = "&recipe=Decade Lock"; 
	}
	elsif ($recipe == 2) {
		$sugarrecipe = "&recipe=Minimize Repeated Tracks"; 
	}
	elsif ($recipe == 3) {
		$sugarrecipe = "&recipe=Prefer Artist Type"; 
	}
	elsif ($recipe == 4) {
		$sugarrecipe = "&recipe=Prefer General Seed Genre"; 
	}
	elsif ($recipe == 5) {
		$sugarrecipe = "&recipe=Prefer Similar Titles"; 
	}
	elsif ($recipe == 6) {
		$sugarrecipe = "&recipe=Prefer Unplayed Tracks"; 
	}
	elsif ($recipe == 7) {
		$sugarrecipe = "&recipe=Use Ratings"; 
	}
	#####
	# GET CLOCK TIME & DATE
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	if ($hour < 10) {$hour = "0$hour"};			# Add 0 padding to hour if required 
	$myfilter = $prefs->get('sugarfilter'.$hour);
	
#	$log->debug("\nACTIVE FILTER at $hour; $myfilter\n"); 

	$mystyle = ("&style=" . $mystyle);
	$myvariety = ("&variety=" . $myvariety);
	$myfilter = ("&filter=" . $myfilter);
}		
	
sub playlistcull {
	my $client = shift;
	my $songIndex = Slim::Player::Source::streamingSongIndex($client);
    my $songsToKeep = 5;

		if ($songIndex && $songsToKeep ne '' && $songIndex > $songsToKeep) {
			# Delete tracks before this one on the playlist
			for (my $i = 0; $i < $songIndex - $songsToKeep; $i++) {
				my $request = $client->execute(['playlist', 'delete', 0]);
			}
		}
}  

#
#  Use the playing track and send to MusicIP to recommend a list of tracks
#
sub buildMIPReq { 
	my $client = shift;
	my $mytitle = shift;
	# Filter protection, MusicIP breaks like an egg if you request a filter that doesnt exist, check filter is set before sending!
	# 0 is where filter is set to none in the plugin page
	# Build MusicIP URL request
	my $mypageurl;
	if ($myfilter eq "&filter=0" || $myfilter eq "&filter=") {
		$mypageurl = ("http://localhost:" . $mymipport . "/api/mix\?song=" . $mytitle . $mystyle .$myvariety); 						# Build MusicIP URL request
	} else {
		$mypageurl = ("http://localhost:" . $mymipport . "/api/mix\?song=" . $mytitle . $mystyle . $myvariety . $myfilter);
	}

	if ($recipe !=0) {$mypageurl = ($mypageurl . $sugarrecipe);}

	return $mypageurl;
}

sub sleepplayer {
	my $client = shift;
	if ($sugarcubesleep_flag == '1') {		#  LETS SLEEP
		if ($sleepgov == '0') {				
			# GET CLOCK TIME & DATE
			my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
			$hour = $hour+0;
			my $fromhour;
			my $tohour;
			$fromhour = $scsleepfrom;
			$tohour = $scsleepto;
			$fromhour = $fromhour+0;
			$tohour = $tohour+0;
			if ($fromhour - $hour <= 0 && $tohour - $hour <= 0 || $fromhour - $hour >= 0 && $tohour - $hour > 0)  {
				$scsleepduration = $scsleepduration*60;		# Seconds to minutes
				$log->debug("\nSleep Player; $scsleepduration");
				$client->execute(["sleep", $scsleepduration]);
				$sleepgov = '1';								# We have already slept
				my $scresettimer;
				$scresettimer = $scsleepduration + 30;
				Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $scresettimer, \&resetSleepgov, );
			} else {
#				$log->debug("\nNo SLEEP");
#				$log->debug("\nHour; $hour, $scsleepfrom; $scsleepto");					
			}
		}
	}
}

sub resetSleepgov { 		# Should fire 30secs after we have slept
	$log->debug("\nSleep Player Sleepgov Reset");
	$sleepgov = '0'; 
}			# Reset our counter that we use to check whether we have already requested client to sleep

sub SendtoMIPSync {
	my $client = shift;
	my $mypageurl = shift;
	my @test;
	my %test;
	my @unique;
	my $element;
	my $track;
	my $url;

	my $http = LWP::UserAgent->new;
	$http->timeout(5);
	my $response = $http->get($mypageurl);
	my $content = $response->content;
	
	if ($response->is_success) {$log->debug("Response Ok\n");}
	else {$log->debug("MIP Response Failed\n");}

	my @miparray = split(/\n/, $content);
	my $dumpindex;
	$log->debug("\nB4MIPArray\n");					#dump out array
	for ($dumpindex=0; $dumpindex<$#miparray+1; $dumpindex++)
	{$log->debug("@miparray[$dumpindex]\n");}
	
	my $changeindex;
	$log->debug("\nTidyArray\n");					#dump out array
	for ($changeindex=0; $changeindex<$#miparray+1; $changeindex++)
	{
	my $enc = Slim::Utils::Unicode::encodingFromString(@miparray[$changeindex]);
	$element = Slim::Utils::Unicode::utf8decode_guess(@miparray[$changeindex], $enc);
	my $newPath = convertPath($element);
	if ( -e $newPath || -e Slim::Utils::Unicode::utf8encode_locale($newPath) ) {
	my $url = Slim::Utils::Misc::fileURLFromPath($element);
	$track = Slim::Schema->objectForUrl({'url' => $url});} 
	$log->debug("Tidy Element; $element\n");
	splice(@miparray,$changeindex,1,$element);
	}
	my $uniqueindex;
	@test{ map { lc } @newtrackarray } = ();
	@unique = grep { !exists $test{lc $_} } @miparray;

	$log->debug("\n#CleanArray#\n");					#dump out array
	for ($uniqueindex=0; $uniqueindex<$#unique+1; $uniqueindex++)
	{$log->debug("@unique[$uniqueindex]\n");}
	my $track = selecttrack($client, \@unique);			# Randomly select track
	return $track
}

sub selecttrack {	
	my $client = shift;
	my $miparray = shift;
	my $element;
	my $track;
	
    my $index = rand @$miparray;
    $element = $miparray->[$index];
	if (length($element) <1) {				# error correction routine, sometimes random number is bigger than length of array
		$element = $miparray->[$index-1];			#if so then drop back down and pull out again to ensure we have a valid element
	}
	if ($sugarmip_flag == 1) {
	$element = $miparray->[0];		# Take First clean track from array - Prefer Track Return Order
	}
	$log->debug("\nSelected Element; $element\n");	
	my $newPath = convertPath($element);
	if ( -e $newPath || -e Slim::Utils::Unicode::utf8encode_locale($newPath) ) {
	my $url = Slim::Utils::Misc::fileURLFromPath($element);
	$track = Slim::Schema->objectForUrl({'url' => $url});} 
	
	if ($track == "") {
	$log->info("\nTrack Add Failed; $element\n");
	} else { 
	$log->info("\nTrack Add OK-'$element'\n");
	$log->info("\nTrack; $track\n");
	push (@newtrackarray, $element);			# Store element on tracking array.
	}
	return $track
}
sub addtrack {
	my $client = shift;
	my $track = shift;

	$log->info("client;$client track; $track\n");
	my $request = $client->execute(["playlist", "add", $track]);   # Our new track add to SC
	$request->source('PLUGIN_SUGARCUBE');

	my $dumpindex=0;
	$log->debug("\nTracking Array\n");					#dump out array
	for ($dumpindex=0; $dumpindex<$#newtrackarray+1; $dumpindex++)
	{$log->debug("@newtrackarray[$dumpindex]\n");}
}
sub slideVolume {
	my $client = shift;
	#
	## VOLUME CHANGE
	#
	my $volumeslide = Slim::Player::Client::volume($client);			# GET CURRENT VOLUME
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$hour = $hour+0;
	my $fromhour;
	my $tohour;
	$fromhour = $sugarcubevolumetime;
	$tohour = $sugarcubevolumetimeend;
	$fromhour = $fromhour+0;
	$tohour = $tohour+0;
	if ($fromhour - $hour <= 0 && $tohour - $hour <= 0 || $fromhour - $hour >= 0 && $tohour - $hour > 0)
	{
#		$log->debug("\nAfter Hours Changing volume to; $volumeslide");
		$volumeslide = $volumeslide - $sugarcubevolume;

		if ($volumeslide < 0) { $volumeslide = 0; }

		$client->execute(["mixer", "volume", $volumeslide]);
	} else {
#		$log->debug("\nNO Change to Volume");
	}
}
 
sub grabFilters {
	my @filters    = ();
	my %filterHash = ();
	
	my $MMSport = $prefs->get('sugarport');

	my $http = Slim::Player::Protocols::HTTP->new({
		'url'    => "http://localhost:$MMSport/api/filters",
		'create' => 0,
	});
	if ($http) {
		@filters = split(/\n/, $http->content);
		$http->close;
	}
	my $none = sprintf('(%s)', Slim::Utils::Strings::string('NONE'));
	push @filters, $none;
	foreach my $filter ( @filters ) {
		if ($filter eq $none) {
			$filterHash{0} = $filter;
			next
		}
		$filterHash{$filter} = $filter;
	}
	return \%filterHash;
}

########### Dynamic Playlist integration start ##############
sub isDynamicPlaylistActive {
	my $client = shift;

	my $playlist = undef;
	if(UNIVERSAL::can("Plugins::DynamicPlayList::Plugin","getCurrentPlayList")) {
		no strict 'refs';
		$playlist = eval { &{"Plugins::DynamicPlayList::Plugin::getCurrentPlayList"}($client) };
		if ($@) {
			$log->error("Error calling DynamicPlaylist plugin: $@\n");
		}
		use strict 'refs';
	}
	if(defined($playlist) && $playlist =~ /^sugarcube/) {
		return 1;
	}else {
		return 0;
	}
	
}

sub getDynamicPlayLists {
	my ($client) = @_;

	my %result = ();
	
	my %fullPlaylist = (
		'id' => 'sugarcube',								# Unique identifier of the dynamic playlist
		'name' => string('PLUGIN_SUGARCUBE'),				# Text to display to the user
		'url' => 'plugins/SugarCube/settings/basic.html?',	# URL to page where the user can change the mix settings
	);
	$result{'sugarcube'} = \%fullPlaylist;
	
	return \%result;
}

sub getNextDynamicPlayListTracks {
	my ($client,$dynamicplaylist,$limit,$offset,$parameters) = @_;
	my $song = undef;
	my $currentSongTrack = undef;
	my $track;
	
	# If this isn't the first time
	if($offset) {
		# Base mix of last returned song for this player
		$song = $lastDynamicPlaylistTrack{$client};
	}

	# If this is the first time or no suitable song has been selected yet
	if(!defined($song)) {
		# Base mix of currently playing song
		$currentSongTrack = Slim::Player::Playlist::song($client);
		if(defined($currentSongTrack) && Slim::Music::Info::isFileURL($currentSongTrack->url)) {
			$song = $currentSongTrack->url;
		}else {
			$currentSongTrack = undef;
		}
	}
	# If no suitable start track was found, base start of mix of a random track
	if(!defined($song)) {
		$track = Slim::Schema->rs('Track')->search(undef,{ 'order_by' => \'RAND()'})->single;
		$song = $track->url;
	}
	my $mytitle = SaveMyCurrentTrack($client,$song);				#  Strip and Store played track Latin1 format
	my $element = getMIPPath($client, $mytitle);
	refreshCube();		# Check settings
	my $mypageurl = buildMIPReq($client, $mytitle);			# Routine to get MIP settings and build MIP request
	$track = SendtoMIPSync($client,$mypageurl);
	
	my $bigtrack=@newtrackarray;					
	if ($bigtrack > $sugarslide) 						# After playing x tracks, wipe first element of the Tracking Array of our played tracks
	{shift(@newtrackarray);}
	
	my @result = ();

	if($track) {
		$log->debug("returning to Dynamic Playlist $track");
		$lastDynamicPlaylistTrack{$client} = $track->url;

		# If we started on currently playing song we need to return that song first
		if(defined($currentSongTrack)) {
			push @result,$currentSongTrack,
		}
		
		# Add new song retreived from MusicIP
		push @result,$track;

	}else {
		$log->error("Couldn't find track for: $track");
	}
	return \@result;
}
########### Dynamic Playlist integration end ################

#### Following sub routine is taken from musicmagic plugin so that we can have MIP disabled but still function

sub convertPath {
	my $mmsPath = shift;	
	if ($prefs->get('host') eq 'localhost') {
		return $mmsPath;
	}
	my $remoteRoot = $prefs->get('remote_root');
	my $nativeRoot = preferences('server')->get('audiodir');
	my $original   = $mmsPath;
	my $winPath    = $mmsPath =~ m/\\/; # test if this is a windows path
	my $os  = Slim::Utils::OSDetect::OS();				# Work out what OS we are

	if ($os eq 'unix') {

		# we are unix
		if ($winPath) {

			# we are running musicip on windows but
			# slim server is running on unix

			# convert any windozes paths to unix style
			$remoteRoot =~ tr/\\/\//;

			$log->debug("$remoteRoot :: $nativeRoot");

			# convert windozes paths to unix style
			$mmsPath =~ tr/\\/\//;
			# convert remote root to native root
			$mmsPath =~ s/$remoteRoot/$nativeRoot/;
		}

	} else {

		# we are windows
		if (!$winPath) {

			# we recieved a unix path from music match
			# convert any unix paths to windows style
			# convert windows native to unix first
			# cuz matching dont work unless we do
			$nativeRoot =~ tr/\\/\//;

#			$log->debug("$remoteRoot :: $nativeRoot");

			# convert unix root to windows root
			$mmsPath =~ s/$remoteRoot/$nativeRoot/;
			# convert unix paths to windows
			$mmsPath =~ tr/\//\\/;
		}
	}

#	$log->debug("$original is now $mmsPath");

	return $mmsPath
}
1;
__END__
