package Plugins::SugarCube::Settings;

use strict;
use base qw(Slim::Web::Settings);
use Slim::Utils::Prefs;

my $prefs = preferences('plugin.SugarCube');

#$prefs->migrate(1, sub {
#	$prefs->set('txt2',      Slim::Utils::Prefs::OldPrefs->get('txt2')      || 'World' );
#	1;
#});

sub name {
	return Slim::Web::HTTP::protectName('PLUGIN_SUGARCUBE');
}
sub page {
	return Slim::Web::HTTP::protectURI('plugins/SugarCube/settings/basic.html');
}

sub handler {
	my ($class, $client, $params) = @_;
	if ($params->{'saveSettings'})
	{
	
		my $sugarcube_flag = $params->{'sugarcube_flag'};
		$prefs->set('sugarcube_flag', $params->{'sugarcube_flag'});
	
		my $sugarmip_flag = $params->{'sugarmip_flag'};
		$prefs->set('sugarmip_flag', "$sugarmip_flag");

		my $sugarport = $params->{'sugarport'};
		$prefs->set('sugarport', "$sugarport");

		my $sugarstyle = $params->{'sugarstyle'};
		$prefs->set('sugarstyle', "$sugarstyle");

		my $sugarvariety = $params->{'sugarvariety'};
		$prefs->set('sugarvariety', "$sugarvariety");
	
		my $recipe = $params->{'recipe'};
		$prefs->set('recipe', "$recipe");	

		my $sugarslide = $params->{'sugarslide'};
		$prefs->set('sugarslide', "$sugarslide");
		
		my $sugarcleartracks = $params->{'sugarcleartracks'};
		$prefs->set('sugarcleartracks', "$sugarcleartracks");

		my $sugarcubevolume_flag = $params->{'sugarcubevolume_flag'};
		$prefs->set('sugarcubevolume_flag', "$sugarcubevolume_flag");

		my $sugarcubevolumetime = $params->{'sugarcubevolumetime'};
		if ($sugarcubevolumetime < 10 && (length($sugarcubevolumetime) < 2)) { $sugarcubevolumetime = "0$sugarcubevolumetime"};			# Add 0 padding to hour if required 
		$prefs->set('sugarcubevolumetime', "$sugarcubevolumetime");

		my $sugarcubevolumetimeend = $params->{'sugarcubevolumetimeend'};
		if ($sugarcubevolumetimeend < 10 && (length($sugarcubevolumetimeend) < 2)) { $sugarcubevolumetimeend = "0$sugarcubevolumetimeend"};			# Add 0 padding to hour if required 
		$prefs->set('sugarcubevolumetimeend', "$sugarcubevolumetimeend");
		
		my $sugarcubevolume = $params->{'sugarcubevolume'};
		$prefs->set('sugarcubevolume', "$sugarcubevolume");
	
		my $sugarcubesleep = $params->{'sugarcubesleep'};
		$prefs->set('sugarcubesleep', "$sugarcubesleep");

		my $sugarcubevolumesleep = $params->{'sugarcubevolumesleep'};
		if ($sugarcubevolumesleep < 10 && (length($sugarcubevolumesleep) < 2)) { $sugarcubevolumesleep = "0$sugarcubevolumesleep"};			# Add 0 padding to hour if required 
		$prefs->set('sugarcubevolumesleep', "$sugarcubevolumesleep");

		my $sugarcubevolumesleepend = $params->{'sugarcubevolumesleepend'};
		if ($sugarcubevolumesleepend < 10 && (length($sugarcubevolumesleepend) < 2)) { $sugarcubevolumesleepend = "0$sugarcubevolumesleepend"};			# Add 0 padding to hour if required 
		$prefs->set('sugarcubevolumesleepend', "$sugarcubevolumesleepend");

		my $scsleepduration = $params->{'scsleepduration'};
		$prefs->set('scsleepduration', "$scsleepduration");

		my $sugarcubesleep_flag = $params->{'sugarcubesleep_flag'};
		$prefs->set('sugarcubesleep_flag', "$sugarcubesleep_flag");

		my $scsleepfrom = $params->{'scsleepfrom'};
		if ($scsleepfrom < 10 && (length($scsleepfrom) < 2)) { $scsleepfrom = "0$scsleepfrom"};			# Add 0 padding to hour if required 
		$prefs->set('scsleepfrom', "$scsleepfrom");

		my $scsleepto = $params->{'scsleepto'};
		if ($scsleepto < 10 && (length($scsleepto) < 2)) { $scsleepto = "0$scsleepto"};			# Add 0 padding to hour if required 
		$prefs->set('scsleepto', "$scsleepto");

		for(my $hour=0;$hour<24;$hour++) {
			my $postfix = $hour;
			if($hour<10) {
				$postfix = '0'.$hour;
			}	
			$prefs->set('sugarfilter'.$postfix,$params->{'sugarfilter'.$postfix});
		}

		Plugins::SugarCube::Plugin->refreshCube();
	}

	$params->{'prefs'}->{'sugarcube_flag'} = $prefs->get('sugarcube_flag');
	$params->{'prefs'}->{'sugarmip_flag'} = $prefs->get('sugarmip_flag');
	$params->{'prefs'}->{'sugarport'} = $prefs->get('sugarport');
	$params->{'prefs'}->{'sugarstyle'} = $prefs->get('sugarstyle');
	$params->{'prefs'}->{'sugarvariety'} = $prefs->get('sugarvariety');
	$params->{'prefs'}->{'recipe'} = $prefs->get('recipe');	
	$params->{'prefs'}->{'sugarslide'} = $prefs->get('sugarslide');
	$params->{'prefs'}->{'sugarcleartracks'} = $prefs->get('sugarcleartracks');
	$params->{'prefs'}->{'sugarcubevolume'} = $prefs->get('sugarcubevolume');
	$params->{'prefs'}->{'sugarcubevolumetime'} = $prefs->get('sugarcubevolumetime');
	$params->{'prefs'}->{'sugarcubevolume_flag'} = $prefs->get('sugarcubevolume_flag');
	$params->{'prefs'}->{'sugarcubevolumetimeend'} = $prefs->get('sugarcubevolumetimeend');
	$params->{'filters'}  = grabFilters();
	$params->{'prefs'}->{'scsleepduration'} = $prefs->get('scsleepduration');
	$params->{'prefs'}->{'sugarcubesleep_flag'} = $prefs->get('sugarcubesleep_flag');
	$params->{'prefs'}->{'scsleepfrom'} = $prefs->get('scsleepfrom');
	$params->{'prefs'}->{'scsleepto'} = $prefs->get('scsleepto');
	$params->{'prefs'}->{'sugarfilter'} = $prefs->get('sugarfilter00');	

	for(my $hour=0;$hour<24;$hour++) {
		my $postfix = $hour;
		if($hour<10) {
			$postfix = '0'.$hour;
		}	
		$params->{'prefs'}->{'sugarfilter'.$postfix} = $prefs->get('sugarfilter'.$postfix);	
	}
	
	return $class->SUPER::handler($client, $params);
}

#  Following grabFilters subroutine has been taken from the MIP plugin and recoded to work with SugarCube
#  Thanks go out to the devs :)
sub grabFilters {
	my @filters    = ();
	my %filterHash = ();
	
	my $MMSport = $prefs->get('sugarport');

	my $http = Slim::Player::Protocols::HTTP->new({
		'url'    => "http://localhost:$MMSport/api/filters",
		'create' => 0,
	});
	if ($http) {
		@filters = split(/\n/, $http->content);
		$http->close;
	}
	my $none = sprintf('(%s)', Slim::Utils::Strings::string('NONE'));
	push @filters, $none;
	foreach my $filter ( @filters ) {
		if ($filter eq $none) {
			$filterHash{0} = $filter;
			next
		}
		$filterHash{$filter} = $filter;
	}
	return \%filterHash;
}

1;

__END__
