#  SpiceFly - SugarCube - Copyright 2008 Charles Parker
#
#  Developed by Charles Parker - http://www.spicefly.com/
#  Based on framework and plugin; NowPlaying.pm by Max Spicer ( http://www.thespicers.net/slim.html#nowPlaying)
#
#  What SugarCube does
#    SugarCube achieves my desire for SqueezeCentre and MusicIP to just get on with playing music.
#     Once installed, just play a track,  this will then become the seed track and your journey begins through your music library.
#      Using this seed, SugarCube asks MusicIP for a selection and then chooses one and queues it up to play.
#      Once the first track ends, the second track is now your seed track and so on and so on! 
#       Therefore you are taken on a journey through your music library without all the hassle of playlists
#      or lots of key pressing, you never experience the same list ever or reach the end!  
#
#   Version 0.5 - Internal Release ;)
#  Added Filter check before sending to MusicIP 
#
#   Version 1.0 - Released 25th June 2008
#   First Public Release
#
#   Version 1.1 - Released 25th June 2008
#   Optimised code for SC Injection of new track, removing the need for the Web API CAUTH  - Michael (mherger)
#
#   Version 1.2 - Released 26th June 2008
#   Depreciated port name and numbers for MIP and SC, SC no longer required as we inject via different methods, 
#    MIP port is read from MIP settings as we assume that MIP is running on the same machine as SC
#   MIP Settings are used for the Variety, Filter and Style settings.  Plugin is now hands free requiring no configuration.
#   MIP Settings are read dynamically before selecting the next track, so changes are pretty immediate.
#   Enable/Disable via Extra Menu - Always starts up disabled by default
#   Plugin version SC 7.2 enabled as it appears to work ok
#   
#   Version 1.2.1 - Released 26th June 2008
#   Fixed typo errors which broke the path correction formatting for MIP 
#  
#  Version 1.2.2 - Released 27th June 2008
#   Added failback state for when we dont find any port, variety, filter or style settings.
#
#  Version 1.2.3 - Released 28th June 2008
#  Added Linux/Unix check and path fix before MIP query
#
#  Version 1.3
#  Skip bad luck release ;)
#
#  Version 1.4 - 7th July 2008
#  = Some removal and tidy up of code, removal of some unrequired scalars.
#  = Functions split to make it easier to maintain and develop.
#  + Added first effort at stopping repeat tracks, will now try 4 times to select a track not played before, after this time it allows the track to be added
#      does not go back to MIP as this may have potential to cause some performance issues hitting MIP quickly for requests?
#  + Added Web interface to enable settings and enable/disable via web page
#  + Added support for MIP Mix Recipes (A SqueezeCentre first =)   (Moods are not available yet via MIP Headless as of MIP1.9b5)
#  + Added Schedule filter, ie. alternative MIP filter so that can vary tracks, for example more dance during day and start sending more chilled out in evening
#  - Removed Playlist culling as adding tracks and removing tracks quickly causes SC to fire newsong notifications even though its not a newsong :s  function to be revisted
#  - Removed dependency on MIP settings, use our own to reduce complexity
#
#   Version 1.4.1 - 8th July 2008
#   +  Added routine to enable track selection from top of results, in some situations MIP may put greater bias on the first result as better matching the original seed track (says MusicIP =)
#       this is a try it and see if you prefer it option :)
#  = Fixed error with padding of filter times in web settings page
#  +  Added purge routine, to wipe tracking array after playing 30 tracks ( will require improvement e.g sliding array dropping tracks from start of array)
#  +  Added ' replacement before submitting to MIP - caused the notify error nemesis
#  = Fixed '&' replacement before submitting to MIP, was only replacing the first '&' it found in the dir/filename rather than all of them!  - caused the notify error nemesis
#  = Fixed debugging output that was not using the debug routine, should be quiet now assuming not running in debug mode
#
#  Version 1.4.2 - 9th July 2008
#  +  Added sliding tracking array, user-definable for how many tracks to remember before allowing a repeat
# +   Added routine to protect against the situation when track "select from top" is active and selected track has already been played, will now pick randomly from MIP results
#      to try and work its way out of the hole.
#  =  Few tweaks and tidy up of the code
#
#  Version 1.4.3 - 10th July 2008
#  +  Improved the power up function should enable correctly (if applicable) on startup
#  +  Added fixes for the following characters in track names   +  ,  [  ]  before submitting to MIP
#  +  Added fixes for the following characters in track names        before submitting to MIP
#  =  Fixed SugarCube would disable if playing was stopped
#  +  Added setting to enable forgetting, so if playlist is cleared - clear our previous played tracking array
#  +  Added simple function to breakout mirroring of first track when using select from top, we bounce it to force a random selection from the results. 
#
#  Version 1.4.4 - 20th July 2008
#  = Fixed Enable/Disable routine so it works with the Squeezebox Duet, configuration still via web page (for now)
#  +  Added Dropdown filter lists in the web configuration page, poached from the MIP plugin (thanks guys)
#
#  Version 1.5 - 9th Sept 2008
#  + Added volume fade option, to gradually step down the volume each track change, perfect as a nightime aid for sleeping  ;)
# + Added Player Sleep functionality, to shutoff the player after a specified time
#  This now allows a single track selection to kickoff MIP mixing with automatic volume fading and player sleep
# + Change of code for encoding track before sending to MIP, this is hopefully the proper coding and escaping method
# + Because of change above, rewrite of tracking array which should fix the first selection matching the first track issue
# + Added code to protect against multiple notifications when players are synced
# + Improved filter selection, can now specify different MIP filters each hour 
# = Tidy up of scalars
#
# Version 1.5.1 - 16th Sept 2008
# = Removal of Linux/Unix fudge workaround which is no longer required (Thanks Erland)
#
#
#  To Do List; 
#        His n Her functions so multiple users can have different filter and selection criteria
#        Switch over out Web MIP Call function to Async 
#        Add full Squeezebox Controller support
#        Fix foreign characters 
#       Support user-defined recipes
#
# Known Errors;
#  Doesnt like tracks with foreign characters in the folder or file name, wont break but wont add them, this only affects queuing of track to SC and not MIP request
#  If you have a small music collection or a tight selection criteria on the filter then you may get duplication of tracks.
#
#  Pre-Reqs
#   MusicIP running in headless mode or running  with the GUI permanently open with API enabled
#
#   Installation Details;
#  1)  Copy folder into your plugin folder e.g.C:\program Files\SqueezeCenter\server\Plugins\SugarCube
#  2)  Shutdown and restart SqueezeCentre to load the plugin
#  3)  Once SqueezeCentre is up, navigate to the Plugin Settings page and configure SugarCube
#  4)  Once configured SugarCube can be enabled/disabled via the Extra Menu
#  5)  Sit back and enjoy your collection.
#  6)  Note to go back to normal playing mode, you need to go to the Extra menu to disable SugarCube
#
# This code is derived from code with the following copyright message:
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

package Plugins::SugarCube::Plugin;
use base qw(Slim::Plugin::Base);
use strict;
use Slim::Utils::Misc;
use Slim::Utils::Prefs;
use Slim::Utils::Log;
use Slim::Utils::Strings qw(string);
use Slim::Control::Request;
use Slim::Utils::OSDetect;
use Plugins::SugarCube::Settings;
use Scalar::Util qw(blessed);
use DBI qw(:sql_types);
use Slim::Utils::Timers;
###############################################################################
my $mystyle;
my $myvariety;
my @newtrackarray=();
my $myfilter;
my $mymipport;
our @browseMenuChoices;
my %menuSelection;
my $line;
my $myos;	
my $sugarcube_flag;		# Whether on or off
my $sugarmip_flag;		# Take from top of MIP array
my $sugarport;
my $sugarstyle;
my $sugarvariety;
my $recipe;
my $sugarrecipe;		# Track whether to use recipe
my $prefs = preferences('plugin.SugarCube');
my $sugarslide;			# Sliding array size
my $sugarcleartracks;	# Forget Flag 
my $sugarcubevolume_flag; # Yes slide volume
my $sugarcubevolumetime;   # Time to slide volume
my $sugarcubevolume;		# Slide volume by
my $sugarcubevolumetimeend;  # End time to slide volume
my $sugarcubesleep_flag;
my $scsleepfrom;
my $scsleepto;
my $scsleepduration;
my $sleepgov;				# Save state have we activated a sleep already
my $ignorerequest;			# Toggle for multiple players
########### Dynamic Playlist integration start ##############
my %lastDynamicPlaylistTrack = ();
my %dynamicPlaylistActive = ();
########### Dynamic Playlist integration end ##############
#
#

my @browseMenuChoices = (
	'PLUGIN_SUGARCUBE_FLAG_ON',		## These are enable disable functions for sugarcube
	'PLUGIN_SUGARCUBE_FLAG_OFF'
	);

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.sugarcube',
	'defaultLevel' => 'INFO',
	'description'  => getDisplayName(),
});

sub initPlugin {
	my $class = shift;
	$class->SUPER::initPlugin();
	$sleepgov = '0';
	$myos  = Slim::Utils::OSDetect::OS();				# Work out what OS we are
	Plugins::SugarCube::Settings->new;
	
	if ($prefs->get('sugarcube_flag') eq '') {				# Setup defaults if not set
		$prefs->set('sugarcube_flag', "0");
	}
	$sugarcube_flag = $prefs->get('sugarcube_flag');
	
	if ($prefs->get('sugarmip_flag') eq '') {	
		$prefs->set('sugarmip_flag', "0");
	}
	$sugarmip_flag = $prefs->get('sugarmip_flag');

	if ($prefs->get('sugarport') eq '') {	
		$prefs->set('sugarport', "10002");
	}
	$sugarport = $prefs->get('sugarport');
	
	if ($prefs->get('sugarstyle') eq '') {	
		$prefs->set('sugarstyle', "60");
	}
	$sugarstyle = $prefs->get('sugarstyle');

	if ($prefs->get('sugarvariety') eq '') {	
		$prefs->set('sugarvariety', "2");
	}
	$sugarvariety = $prefs->get('sugarvariety');

	if ($prefs->get('recipe') eq '') {	
		$prefs->set('recipe', "0");
	}
	$recipe = $prefs->get('recipe');

	for(my $hour=0;$hour<24;$hour++) {
		my $postfix = $hour;
		if($hour<10) {
			$postfix = '0'.$postfix;
		}
		if (!$prefs->get('sugarfilter'.$postfix)) {	
			$prefs->set('sugarfilter'.$postfix, "0");
		}
	}
	
	if ($prefs->get('sugarslide') eq '') {	
		$prefs->set('sugarslide', "30");
	}
	$sugarslide = $prefs->get('sugarslide');
	
	if ($prefs->get('sugarcleartracks') eq '') {	
		$prefs->set('sugarcleartracks', "1");
	}
	$sugarcleartracks = $prefs->get('sugarcleartracks');
	
	if ($prefs->get('sugarcubevolume_flag') eq '') {	
		$prefs->set('sugarcubevolume_flag', "0");
	}
	$sugarcubevolume_flag = $prefs->get('sugarcubevolume_flag');
	
	if ($prefs->get('sugarcubevolumetime') eq '') {	
		$prefs->set('sugarcubevolumetime', "23");
	}
	$sugarcubevolumetime = $prefs->get('sugarcubevolumetime');
	
	if ($prefs->get('sugarcubevolumetimeend') eq '') {	
		$prefs->set('sugarcubevolumetimeend', "07");
	}
	$sugarcubevolumetimeend = $prefs->get('sugarcubevolumetimeend');
	
	if ($prefs->get('sugarcubevolume') eq '') {	
		$prefs->set('sugarcubevolume', "1");
	}
	$sugarcubevolume = $prefs->get('sugarcubevolume');
	
	if ($prefs->get('sugarcubesleep_flag') eq '') {	
		$prefs->set('sugarcubesleep_flag', "0");
	}
	$sugarcubesleep_flag = $prefs->get('sugarcubesleep_flag');
	
	if ($prefs->get('scsleepfrom') eq '') {	
		$prefs->set('scsleepfrom', "0");
	}
	$scsleepfrom = $prefs->get('scsleepfrom');
	
	if ($prefs->get('scsleepto') eq '') {	
		$prefs->set('scsleepto', "0");
	}
	$scsleepto = $prefs->get('scsleepto');
	
	if ($prefs->get('scsleepduration') eq '') {	
		$prefs->set('scsleepduration', "0");
	}
	$scsleepduration = $prefs->get('scsleepduration');
	
	# Listen out for commands
	$log->debug('SugarCube: Setting execute callback');
	Slim::Control::Request::subscribe(\&commandCallback, [['stop', 'power', 'playlist']]);
}

sub shutdownPlugin {
	Slim::Control::Request::unsubscribe(\&commandCallback);
}

sub setMode {
	my $class = shift;
	my $client = shift;
	$log->debug("In Setmode");
	
	if (!defined($menuSelection{$client})) {
		$menuSelection{$client} = 0;
	};
	$client->lines(\&lines);
}
   
my %functions = (
    	'up' => sub  {
    		my $client = shift;
    		my $newposition = Slim::Buttons::Common::scroll($client, -1, ($#browseMenuChoices + 1), $menuSelection{$client});
    		$menuSelection{$client} =$newposition;
    		$client->update();
    	},
    	'down' => sub  {
    		my $client = shift;
    		my $newposition = Slim::Buttons::Common::scroll($client, +1, ($#browseMenuChoices + 1), $menuSelection{$client});
    		$menuSelection{$client} =$newposition;
    		$client->update();
    	},
		'left' => sub  {
    		my $client = shift;
			$log->debug("In Left");
    		Slim::Buttons::Common::popModeRight($client);
    	},
    	'right' => sub {
    		my $client = shift;
			my @oldlines = $client->curLines();
			my $choice = $browseMenuChoices[$menuSelection{$client}];
			$log->debug("RIGHT - Menu Choice; $choice");
			if ($choice eq 'PLUGIN_SUGARCUBE_FLAG_ON')
			{				# Turn ON						
				$line = $client->string('PLUGIN_SUGARCUBE_ON');
				$sugarcube_flag = '1';
				$prefs->set('sugarcube_flag', "$sugarcube_flag");
				$client->showBriefly({'line1' =>  $client->string('PLUGIN_SUGARCUBE'), 'line2' => $line},{ 'duration' => 5, 'block' => 0 } );
		
			# Enabled so blow up playlist to reduce any playlist tracking issues 
			#		$client->execute(["playlist", "clear"]);
			} elsif ($choice eq 'PLUGIN_SUGARCUBE_FLAG_OFF')
			{
				$line = $client->string('PLUGIN_SUGARCUBE_OFF');
				$sugarcube_flag = '0';
				$prefs->set('sugarcube_flag', "$sugarcube_flag");
				$client->showBriefly({'line1' =>  $client->string('PLUGIN_SUGARCUBE'), 'line2' => $line},{ 'duration' => 5, 'block' => 0 } );
			}
		}
);

sub lines {
	my $client = shift;
	my ($line1, $line2, $overlay2);

	$overlay2 = overlay($client);
	$log->debug("In Lines\n");
	$line1 = $client->string('PLUGIN_SUGARCUBE') . " (" . ($menuSelection{$client}+1) . " " . $client->string('OF') . " " . ($#browseMenuChoices + 1) . ")";
	if ($menuSelection{$client} != 0) {
		$line2 = $client->string($browseMenuChoices[$menuSelection{$client}]);
	} else {
		$line2 = $client->string($browseMenuChoices[$menuSelection{$client}]);
	}
	return { 'line1' => $line1, 'line2' => $line2, 'overlay' => $overlay2 };
}

sub getFunctions { 
	return \%functions;
}

sub overlay {
	my $client = shift;
	return $client->symbols('rightarrow');
	return undef;
}

sub commandCallback {
	my $request = shift;
	my $client = $request->client();
	$log->debug("\n#######################\n");
	$log->debug('SugarCube: received command: ' . $request->getRequestString());
	if ($request->isCommand([['power']])) {
		$log->debug('SugarCube: received POWER; REFRESH SETTINGS');
		refreshCube();		# Load Up Preferences
	}
	########### Dynamic Playlist integration start ##############
	if ($request->isCommand([['playlist'], ['newsong']]) && isDynamicPlaylistActive($client)) {
		$log->debug("SugarCube: newsong cmd recevied with active Dynamic Playlist");
		slideVolume($client);
		sleepplayer($client);
	########### Dynamic Playlist integration end ##############
	}elsif($sugarcube_flag == '0') {
			$log->debug("Relax SugarCube DISABLED");
	} elsif ($sugarcube_flag == '1') {
		if ($request->isCommand([['playlist'], ['newsong']])) {
			$log->debug('SugarCube: newsong cmd received');
		
			if (multiplayer($client))		# Lets dance if 1 then we are synced up
			{ 
				$log->debug("\nSugarCube:SYNCED; $ignorerequest");			# Toggle our switch so we ignore the 2nd new song req
				if ($ignorerequest == 0) {
					$ignorerequest = 1;
				} elsif ($ignorerequest == 1) {$ignorerequest = 0;
				}
			} else {
				$ignorerequest = 0;
			}
			$log->debug("\nSugarCube:SYNCED; $ignorerequest");		

			if ($ignorerequest == 0) {
	
				# Get details of current track
				# New code, may not work 100% but will hopefully allow the mix from a foreign character set... though probably wont :s
				# Preps it ready for MIP to receive in the correct codeset

				my $song = Slim::Player::Playlist::url($client);
				my $mytitle = Slim::Utils::Unicode::utf8on(Slim::Utils::Misc::pathFromFileURL($song));

				# To save CPU time, we add now the element to the Tracking array
				my $goldtitle = $mytitle;
				my $k = rindex($goldtitle, '\\');		# Strip down just to the filename
				my $goldelement = (substr($goldtitle, $k+1));		#  Store played track latin1 format
				push (@newtrackarray, $goldelement);		# Add track to array - current playing track to stop next selection matching	
				$log->debug("GOLD; $goldelement\n");

				my $playlistcount = Slim::Player::Playlist::count($client);
		
				my $element = getMIPTrack($client, $mytitle);

				addncleanup($client, $element);		
				playlistcull($client, $playlistcount);					# Routine to cull playlist
				sleepplayer($client);					# Check whether to sleep player or not
		
#				$log->debug("sugarflag; $sugarcube_flag, sugarmip_flag; $sugarmip_flag, recipe; $recipe, sugarport; $sugarport");
				$log->debug("\n#######################\n");
		
			} elsif ($request->isCommand([['stop']])
				|| $request->isCommand([['power']]) && !$client->power()) {

				$log->debug('SugarCube: setting now playing to nothing');
			} elsif ($request->isCommand([['playlist'], ['clear']])) {
				$log->debug('SugarCube: CLEAR');
				if ($sugarcleartracks == '1') {			# Should forget our memory
					$#newtrackarray = -1; 
					my $e=@newtrackarray;	
					$log->debug("\nNewtrackarraySize: $e\n");
				}
			}
		}
	} else {
		return;
	}
}

sub getMIPTrack {
	my $client = shift;
	my $mytitle = shift;

	$mytitle = getMIPPath($mytitle);
	my $mypageurl = buildMIPReq($client, $mytitle);			# Routine to get MIP settings and build MIP request
	my $content = sendtoMIP($client, $mypageurl);				# Send to MIP
	my $miparray = processMIP($client, $content);			# Get MIP response and process
	my $element = selecttrack($client, $miparray);			# Randomly select track
	my $playstate = dupcheck($client, $element);				# Check we havent already played it

	for(my $protectloop=0; $protectloop<4 && $playstate!= '1'; $protectloop++) {
		$log->debug("\nRetry Selection\n");
		$element = selecttrack($client, $miparray, $playstate);				# Randomly select track
		$playstate = dupcheck($client, $element);					# Check we havent already played it
	}

	return $element;
}

sub getMIPPath {
	my $path = shift;

	#  The next bit puts all the ESCAPE codes %20 for space etc. etc.		

	if ($myos eq 'win' || $myos eq 'mac') {
		$path = URI::Escape::uri_escape($path);
	} else {
		$path = Slim::Utils::Misc::escape($path);
	}	
	$path = Slim::Utils::Unicode::utf8encode_locale($path); 
		
	$log->debug("path; $path\n");
			
	$path =~ s{file:////}{//};							# Clean up all this file: malarky
	$path =~ s{file:///}{};							# Clean up all this file: malarky 	
		
#	if ($myos eq 'win') { 
		#$log->debug("OS Running is Windows"); 
#	} 
#	else { 
		#$log->debug("OS Running is NOT Windows"); 
#		$path = ("/" . $path);						# LINUX/UNIX Fix add / to the title
#	}
	return $path;
}

sub getDisplayName {
	return 'PLUGIN_SUGARCUBE';
}

sub refreshCube {
	$log->debug("Settings Refreshing!");
	$sugarcube_flag = $prefs->get('sugarcube_flag');
	$sugarmip_flag = $prefs->get('sugarmip_flag');
	$sugarport = $prefs->get('sugarport');
	$sugarstyle = $prefs->get('sugarstyle');
	$sugarvariety = $prefs->get('sugarvariety');
	$recipe = $prefs->get('recipe');
	$sugarslide = $prefs->get('sugarslide');
	$sugarcleartracks = $prefs->get('sugarcleartracks');
	$sugarcubevolume_flag = $prefs->get('sugarcubevolume_flag');
	$sugarcubevolumetime = $prefs->get('sugarcubevolumetime');
	$sugarcubevolume = $prefs->get('sugarcubevolume');
	$sugarcubevolumetimeend = $prefs->get('sugarcubevolumetimeend');
	$scsleepduration = $prefs->get('scsleepduration');
	$sugarcubesleep_flag = $prefs->get('sugarcubesleep_flag');
	$scsleepfrom = $prefs->get('scsleepfrom');
	$scsleepto = $prefs->get('scsleepto');

	# SugarCube settings
	$mymipport = $sugarport;
	$mystyle = $sugarstyle;
	$myvariety = $sugarvariety;

	if ($recipe == 1) {
		$sugarrecipe = "&recipe=Decade Lock"; 
	}
	elsif ($recipe == 2) {
		$sugarrecipe = "&recipe=Minimize Repeated Tracks"; 
	}
	elsif ($recipe == 3) {
		$sugarrecipe = "&recipe=Prefer Artist Type"; 
	}
	elsif ($recipe == 4) {
		$sugarrecipe = "&recipe=Prefer General Seed Genre"; 
	}
	elsif ($recipe == 5) {
		$sugarrecipe = "&recipe=Prefer Similar Titles"; 
	}
	elsif ($recipe == 6) {
		$sugarrecipe = "&recipe=Prefer Unplayed Tracks"; 
	}
	elsif ($recipe == 7) {
		$sugarrecipe = "&recipe=Use Ratings"; 
	}
	
	#####
	# GET CLOCK TIME & DATE
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	if ($hour < 10) {$hour = "0$hour"};			# Add 0 padding to hour if required 
	$myfilter = $prefs->get('sugarfilter'.$hour);
	
	$log->debug("\nACTIVE FILTER at $hour; $myfilter\n"); 

	$mystyle = ("&style=" . $mystyle);
	$myvariety = ("&variety=" . $myvariety);
	$myfilter = ("&filter=" . $myfilter);
}		
	
sub playlistcull {
	my $client = shift;
	my $playlistcount = shift;

	if ($playlistcount > '3') { 						# Keep the playlist nice and short, otherwise ;)
  
#		Slim::Player::Playlist::removeTrack($client, $curIndex{$client});
#		$log->debug("\nPlaylist got Large, culling\n"); 
#		$client->execute(["playlist", "delete", 0]);
		#Slim::Player::Playlist::removeTrack($client,1);
	}
}  

#
#  Use the playing track and send to MusicIP to recommend a list of tracks
#
sub buildMIPReq { 
	my $client = shift;
	my $mytitle = shift;

	refreshCube();		# Check settings

	# Filter protection, MusicIP breaks like an egg if you request a filter that doesnt exist, check filter is set before sending!
	# 0 is where filter is set to none in the plugin page
	# Build MusicIP URL request
	my $mypageurl;
	if ($myfilter eq "&filter=0" || $myfilter eq "&filter=") {
		$mypageurl = ("http://localhost:" . $mymipport . "/api/mix\?song=" . $mytitle . $mystyle .$myvariety); 						# Build MusicIP URL request
	} else {
		$mypageurl = ("http://localhost:" . $mymipport . "/api/mix\?song=" . $mytitle . $mystyle . $myvariety . $myfilter);
	}

	if ($recipe !=0) {$mypageurl = ($mypageurl . $sugarrecipe);}

	$log->debug("\nrecipe; $sugarrecipe");
	$log->debug("\nUrl; $mypageurl");
	return $mypageurl;
}

sub sleepplayer {
	my $client = shift;
	
	if ($sugarcubesleep_flag == '1') {		#  LETS SLEEP
		if ($sleepgov == '0') {				
			# GET CLOCK TIME & DATE
			my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
			$hour = $hour+0;
			my $fromhour;
			my $tohour;
			$fromhour = $scsleepfrom;
			$tohour = $scsleepto;
			$fromhour = $fromhour+0;
			$tohour = $tohour+0;
			if ($fromhour - $hour <= 0 && $tohour - $hour <= 0 || $fromhour - $hour >= 0 && $tohour - $hour > 0)  {
				$scsleepduration = $scsleepduration*60;		# Seconds to minutes
				$log->debug("\nSleep Player; $scsleepduration");
				$client->execute(["sleep", $scsleepduration]);
				$sleepgov = '1';								# We have already slept
				my $scresettimer;
				$scresettimer = $scsleepduration + 30;
				Slim::Utils::Timers::setTimer($client, Time::HiRes::time() + $scresettimer, \&resetSleepgov, );
			} else {
				$log->debug("\nNo SLEEP");
				$log->debug("\nHour; $hour, $scsleepfrom; $scsleepto");					
			}
		}
	}
}

sub resetSleepgov { 		# Should fire 30secs after we have slept
	$log->debug("\nSleep Player Sleepgov Reset");
	$sleepgov = '0'; 
}			# Reset our counter that we use to check whether we have already requested client to sleep

sub sendtoMIP{
	my $client = shift;
	my $mypageurl = shift;

#	$log->debug("Sent to MIP URL= $mypageurl\n");
	use LWP::Simple;
	my $content = get $mypageurl;
	die "Couldn't get $mypageurl" unless defined $content;
	return $content;
}
 
sub processMIP{ 
	my $client = shift;
	my $content = shift;

	my @miparray = split(/\n/, $content);
	return \@miparray;
}

sub selecttrack {	
	my $client = shift;
	my $miparray = shift;
	my $playstate = shift || 1;
	$log->debug("\nMIPArray-\n@$miparray\n\n");					#dump out array

	my $element ="";
    my $index   = rand @$miparray;
    $element = $miparray->[$index];
	if (length($element) <1) {				# error correction routine, sometimes random number is bigger than length of array
		$element = $miparray->[$index-1];			#if so then drop back down and pull out again to ensure we have a valid element
	}
	if ($sugarmip_flag == '1') 
	{ 			# Take from top :)
		if ($playstate == '2') {			# Check if we arrived here again, ie. track has been played before
			$log->debug("\nTake from top-2ND TIME AROUND\n");
			$element ="";
			$index   = rand @$miparray;
			$element = $miparray->[$index];
			if (length($element) <1) {				# error correction routine, sometimes random number is bigger than length of array
				$element = $miparray->[$index-1];			#if so then drop back down and pull out again to ensure we have a valid element
			}
			$log->debug("\nTake from top-FELL BACK TO RANDOM\n");	
		} 
		else {
			$element = $miparray->[0];					# Ok so we can have our first element
			$log->debug("\nTake from top-TOOK TOP ELEMENT\n");	
		}
	}
	return $element;	
}

sub dupcheck {
	my $client = shift;
	my $element = shift;

	my $enc = Slim::Utils::Unicode::encodingFromString($element) ;
	my $goldelement = Slim::Utils::Unicode::utf8decode_guess($element, $enc);
	
								# This takes our to play track and cuts all the path out leaving just the filename
	my $k = rindex($element, '\\');	# We then check against our tracking hash to see whether we have played it already
    my $e = (substr($element, $k+1));
	$log->debug("\nTrack Check; $e\n");

	my $playstate;		
	if ( grep { $_ eq $e} @newtrackarray ) {
		$log->debug("\nTrack Played Before!\n");
		$playstate = '2';					# 2 = NOT ok to add
    } else {
		$log->debug("\nTrack OK to Add!\n");
		$playstate = '1';					# 1 = ok to add
	}
	
	$e = Slim::Player::Source::playingSongIndex($client);
	$log->debug("\nPlayPosition; $e");
	return $playstate;
}

sub addncleanup {
	my $client = shift;	
	my $element = shift;
	$log->debug("\n\n\nAddTrack-$element\n\n\n");			
	$client->execute(["playlist", "add", $element]);   # Our new track add to SC
	cleanupTrackArray();
	if ($sugarcube_flag == '1') {			# Activated ON
		slideVolume($client);
	}
}

sub cleanupTrackArray {
	$log->debug("\nTracking Array; @newtrackarray");
	my $bigtrack=@newtrackarray;				
	$log->debug("\nTracking Array Size; $bigtrack, sugarslide; $sugarslide");
	if ($bigtrack > $sugarslide) 						# After playing x tracks, wipe first element of Array tracking our played tracks
	{
		shift(@newtrackarray);
		$log->debug("\nRemoved front\n; @newtrackarray");
	}
}

sub slideVolume {
	my $client = shift;
	#
	## VOLUME CHANGE
	#
	my $volumeslide = Slim::Player::Client::volume($client);			# GET CURRENT VOLUME
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
	$hour = $hour+0;
	my $fromhour;
	my $tohour;
	$fromhour = $sugarcubevolumetime;
	$tohour = $sugarcubevolumetimeend;
	$fromhour = $fromhour+0;
	$tohour = $tohour+0;
	if ($fromhour - $hour <= 0 && $tohour - $hour <= 0 || $fromhour - $hour >= 0 && $tohour - $hour > 0)
	{
		$log->debug("\nAfter Hours Changing volume to; $volumeslide");
		$volumeslide = $volumeslide - $sugarcubevolume;

		if ($volumeslide < 0) { $volumeslide = 0; }

		$client->execute(["mixer", "volume", $volumeslide]);
	} else {
		$log->debug("\nNO Change to Volume");
	}
}

sub multiplayer {
	my $client = shift;
	if (Slim::Player::Sync::isSynced($client)) {
		$log->debug("\nTHIS PLAYER IS SYNCED");		
		return 1;
	} else { 
		return 0;
	}
}
 
sub grabFilters {
	my @filters    = ();
	my %filterHash = ();
	
	my $MMSport = $prefs->get('sugarport');

	my $http = Slim::Player::Protocols::HTTP->new({
		'url'    => "http://localhost:$MMSport/api/filters",
		'create' => 0,
	});
	if ($http) {
		@filters = split(/\n/, $http->content);
		$http->close;
	}
	my $none = sprintf('(%s)', Slim::Utils::Strings::string('NONE'));
	push @filters, $none;
	foreach my $filter ( @filters ) {
		if ($filter eq $none) {
			$filterHash{0} = $filter;
			next
		}
		$filterHash{$filter} = $filter;
	}
	return \%filterHash;
}

########### Dynamic Playlist integration start ##############
sub isDynamicPlaylistActive {
	my $client = shift;

	my $playlist = undef;
	if(UNIVERSAL::can("Plugins::DynamicPlayList::Plugin","getCurrentPlayList")) {
		no strict 'refs';
		$playlist = eval { &{"Plugins::DynamicPlayList::Plugin::getCurrentPlayList"}($client) };
		if ($@) {
			$log->error("Error calling DynamicPlaylist plugin: $@\n");
		}
		use strict 'refs';
	}
	if(defined($playlist) && $playlist =~ /^sugarcube/) {
		return 1;
	}else {
		return 0;
	}
	
}

sub getDynamicPlayLists {
	my ($client) = @_;

	my %result = ();
	
	my %fullPlaylist = (
		'id' => 'sugarcube',								# Unique identifier of the dynamic playlist
		'name' => string('PLUGIN_SUGARCUBE'),				# Text to display to the user
		'url' => 'plugins/SugarCube/settings/basic.html?',	# URL to page where the user can change the mix settings
	);
	$result{'sugarcube'} = \%fullPlaylist;
	
	return \%result;
}

sub getNextDynamicPlayListTracks {
	my ($client,$dynamicplaylist,$limit,$offset,$parameters) = @_;
	my $song = undef;
	my $currentSongTrack = undef;

	# If this isn't the first time
	if($offset) {
		# Base mix of last returned song for this player
		$song = $lastDynamicPlaylistTrack{$client};
	}

	# If this is the first time or no suitable song has been selected yet
	if(!defined($song)) {
		# Base mix of currently playing song
		$currentSongTrack = Slim::Player::Playlist::song($client);
		if(defined($currentSongTrack)) {
			$song = $currentSongTrack->url;
		}
	}

	# If no suitable start track was found, base start of mix of a random track
	if(!defined($song)) {
		my $track = Slim::Schema->rs('Track')->search(undef,{ 'order_by' => \'RAND()'})->single;
		$song = $track->url;
	}

	my $mytitle = Slim::Utils::Unicode::utf8on(Slim::Utils::Misc::pathFromFileURL($song));

	# To save CPU time, we add now the element to the Tracking array
	my $goldtitle = $mytitle;
	my $k = rindex($goldtitle, '\\');		# Strip down just to the filename
	my $goldelement = (substr($goldtitle, $k+1));		#  Store played track latin1 format
	push (@newtrackarray, $goldelement);		# Add track to array - current playing track to stop next selection matching	
	$log->debug("GOLD; $goldelement\n");

	my $miptrack = getMIPTrack($client, $mytitle);
	my $url = Slim::Utils::Misc::fileURLFromPath($miptrack);
	my $track = Slim::Schema->objectForUrl({'url' => $url});
	my @result = ();

	if($track) {
		$log->debug("returning to Dynamic Playlist $miptrack");
		$lastDynamicPlaylistTrack{$client} = $url;

		# If we started on currently playing song we need to return that song first
		if(defined($currentSongTrack)) {
			push @result,$currentSongTrack,
		}
		
		# Add new song retreived from MusicIP
		push @result,$track;

		# Clean up old tracks
		cleanupTrackArray($client);
	}else {
		$log->error("Couldn't find track for: $url");
	}
	return \@result;
}
########### Dynamic Playlist integration end ################

1;
__END__
