package Plugins::ButtonHoldSample;

use strict;

use Slim::Buttons::Home;
use Slim::Utils::Misc;
use Slim::Utils::Strings qw(string);
use Slim::Buttons::Playlist;
use Slim::Hardware::IR;
use File::Spec::Functions qw(:ALL);

sub getDisplayName {
	return 'PLUGIN_BUTTONHOLDSAMPLE';
}

my %mapping = (
	'0.hold' => 'holdNumber_0',
	'1.hold' => 'holdNumber_1',
	'2.hold' => 'holdNumber_2',
	'3.hold' => 'holdNumber_3',
	'4.hold' => 'holdNumber_4',
	'5.hold' => 'holdNumber_5',
	'6.hold' => 'holdNumber_6',
	'7.hold' => 'holdNumber_7',
	'8.hold' => 'holdNumber_8',
	'9.hold' => 'holdNumber_9',
	'0.single' => 'dead',
	'1.single' => 'dead',
	'2.single' => 'dead',
	'3.single' => 'dead',
	'4.single' => 'dead',
	'5.single' => 'dead',
	'6.single' => 'dead',
	'7.single' => 'dead',
	'8.single' => 'dead',
	'9.single' => 'dead',
	'0' => 'dead',
	'1' => 'dead',
	'2' => 'dead',
	'3' => 'dead',
	'4' => 'dead',
	'5' => 'dead',
	'6' => 'dead',
	'7' => 'dead',
	'8' => 'dead',
	'9' => 'dead'
);

sub defaultMap { 
	return \%mapping; 
}

sub initPlugin {
	my $class = shift;
	Slim::Hardware::IR::addModeDefaultMapping('playlist',defaultMap());
	my $functref = Slim::Buttons::Playlist::getFunctions();
	$functref->{'holdNumber'} = \&holdNumber;
}

sub holdNumber {
	my $client = shift;
	my $button = shift;
	my $digit = shift;
	msg("Holding button $digit\n");
	$client->showBriefly(
		$client->string( 'PLUGIN_BUTTONHOLDSAMPLE'),
		$client->string( 'PLUGIN_BUTTONHOLDSAMPLE_HOLDING').($digit),
		3);
}


sub strings {
	return <<EOF;
PLUGIN_BUTTONHOLDSAMPLE
	EN	Button Hold Sample

PLUGIN_BUTTONHOLDSAMPLE_HOLDING
	EN	Holding 
EOF

}

1;

__END__
