/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import music.cpp.client.App;
import music.cpp.client.AutomaticTagsDialog;
import music.cpp.client.MusicClient;
import music.cpp.client.Song;
import music.cpp.client.SongLoadingProgress;
import music.cpp.client.StringUtil;
import music.cpp.client.TagWriter;

public class TagEditor
extends JDialog {
    static final String iApply = StringUtil.replace(MusicClient.STRINGS.get("IDSTR_TE_APPLY"), "&", "");
    static final String iMultiSelect = MusicClient.STRINGS.get("IDSTR_TE_MULTISELECT");
    static final String iNoSelect = MusicClient.STRINGS.get("IDSTR_TE_NOSELECT");
    static final String iLoading = MusicClient.STRINGS.get("IDSTR_TE_LOADING");
    static final String iLoadingOf = MusicClient.STRINGS.get("IDSTR_TE_LOADING_OF");
    static final String i1Track = MusicClient.STRINGS.get("IDSTR_TE_TRACK_SINGLE");
    static final String iNTracks = MusicClient.STRINGS.get("IDSTR_TE_TRACK_MULTIPLE");
    static final String iTitle = MusicClient.STRINGS.get("IDSTR_TE_TITLE");
    static final String iTrack = MusicClient.STRINGS.get("IDSTR_TE_TRACK");
    static final String iArtist = MusicClient.STRINGS.get("IDSTR_TE_ARTIST");
    static final String iAlbum = MusicClient.STRINGS.get("IDSTR_TE_ALBUM");
    static final String iGenre = MusicClient.STRINGS.get("IDSTR_TE_GENRE");
    static final String iYear = MusicClient.STRINGS.get("IDSTR_TE_YEAR");
    static final String iComposer = MusicClient.STRINGS.get("IDSTR_TE_COMPOSER");
    static final String iLyricist = MusicClient.STRINGS.get("IDSTR_TE_LYRICIST");
    static final String iOrchestra = MusicClient.STRINGS.get("IDSTR_TE_ORCHESTRA");
    static final String iConductor = MusicClient.STRINGS.get("IDSTR_TE_CONDUCTOR");
    static final String iPublisher = MusicClient.STRINGS.get("IDSTR_TE_PUBLISHER");
    static final String iComments = MusicClient.STRINGS.get("IDSTR_TE_COMMENTS");
    static final String iLyrics = MusicClient.STRINGS.get("IDSTR_TE_LYRICS");
    static final String iTrackInfo = MusicClient.STRINGS.get("IDSTR_TE_TRACK_INFO");
    static final String iExtraInfo = MusicClient.STRINGS.get("IDSTR_TE_ARTIST_INFO");
    static final String iSaving = MusicClient.STRINGS.get("IDSTR_TE_SAVING");
    static final String iSavingOf = MusicClient.STRINGS.get("IDSTR_TE_SAVING_OF");
    static final String iTEAdvanced = MusicClient.STRINGS.get("IDSTR_TE_ADVANCED");
    static final String iTEErrorWriting = MusicClient.STRINGS.get("IDSTR_TE_ERROR_WRITING");
    MusicClient client;
    Vector songs;
    Vector toRefresh = new Vector();
    File[] file;
    String[] title;
    String[] track;
    String[] artist;
    String[] album;
    String[] genre;
    String[] year;
    String[] composer;
    String[] lyricist;
    String[] orchestra;
    String[] conductor;
    String[] publisher;
    String[] comments;
    String[] lyrics;
    boolean[] readOnly;
    JPanel mainPanel;
    JTabbedPane tab;
    DefaultListModel tracksModel;
    JList tracksList;
    JTextArea info1;
    JTextArea info2;
    JTextArea lyricsField;
    JTextArea commentsField;
    JTextField titleField;
    JTextField trackField;
    JTextField artistField;
    JTextField albumField;
    JTextField genreField;
    JTextField yearField;
    JTextField composerField;
    JTextField lyricistField;
    JTextField orchestraField;
    JTextField conductorField;
    JTextField publisherField;
    JCheckBox artistBox;
    JCheckBox albumBox;
    JCheckBox genreBox;
    JCheckBox yearBox;
    JCheckBox composerBox;
    JCheckBox lyricistBox;
    JCheckBox orchestraBox;
    JCheckBox conductorBox;
    JCheckBox publisherBox;
    JButton advanced;
    JButton ok;
    JButton cancel;
    JButton apply;
    JPanel pb1;
    JPanel pb2;
    int[] selection = null;
    boolean finishedLoading = false;
    boolean finishedApply = false;

    public TagEditor(MusicClient musicClient, Vector vector, boolean bl) {
        super(musicClient, MusicClient.STRINGS.get("IDSTR_J_EDIT_TAGS"), true);
        Object object;
        Object object2;
        this.client = musicClient;
        this.songs = new Vector();
        Iterator iterator = vector.iterator();
        Vector<Object> vector2 = new Vector<Object>();
        while (iterator.hasNext()) {
            object2 = (Song)iterator.next();
            object = object2.mp3();
            if (object != null && ((File)object).exists()) {
                this.songs.add(object2);
                continue;
            }
            vector2.add(object2);
        }
        if (vector2.size() > 0) {
            object2 = new StringBuffer();
            iterator = vector2.iterator();
            while (iterator.hasNext()) {
                object = ((Song)iterator.next()).mp3();
                if (object == null) continue;
                ((StringBuffer)object2).append(((File)object).getAbsolutePath() + "\n");
            }
            object = vector2.size() == 1 ? MusicClient.STRINGS.expand("IDSTR_TE_FILE_MISSING", new String[]{((StringBuffer)object2).toString()}) : MusicClient.STRINGS.expand("IDSTR_TE_FILES_MISSING", new String[]{((StringBuffer)object2).toString()});
            if (this.client.confirm(((String)object).toString())) {
                this.client.deleteFromLibrary(vector2, false);
            }
        }
        if (this.songs.size() == 0) {
            return;
        }
        this.file = new File[this.songs.size()];
        this.title = new String[this.songs.size()];
        this.track = new String[this.songs.size()];
        this.artist = new String[this.songs.size()];
        this.album = new String[this.songs.size()];
        this.genre = new String[this.songs.size()];
        this.year = new String[this.songs.size()];
        this.composer = new String[this.songs.size()];
        this.lyricist = new String[this.songs.size()];
        this.orchestra = new String[this.songs.size()];
        this.conductor = new String[this.songs.size()];
        this.publisher = new String[this.songs.size()];
        this.comments = new String[this.songs.size()];
        this.lyrics = new String[this.songs.size()];
        this.readOnly = new boolean[this.songs.size()];
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.tracksModel = new DefaultListModel();
        this.load(null);
        this.tracksList = new JList(this.tracksModel){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(250, 300);
            }
        };
        this.tracksList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TagEditor.this.setSelection(TagEditor.this.tracksList.getSelectedIndices());
            }
        });
        object2 = new JPanel(new BorderLayout());
        ((Container)object2).add("North", new JLabel(this.songs.size() == 1 ? i1Track : iNTracks));
        object = new JScrollPane(this.tracksList);
        ((Container)object2).add("Center", (Component)object);
        this.mainPanel.add("West", (Component)object2);
        this.tab = new JTabbedPane(){

            public Dimension getPreferredSize() {
                return new Dimension(350, 300);
            }
        };
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(iTitle);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iTrack);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iArtist);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iAlbum);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iGenre);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iYear);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.titleField = new JTextField();
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                TagEditor.this.apply.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TagEditor.this.apply.setEnabled(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                TagEditor.this.apply.setEnabled(true);
            }
        };
        this.titleField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.titleField, gridBagConstraints);
        jPanel.add(this.titleField);
        ++gridBagConstraints.gridy;
        this.trackField = new JTextField();
        this.trackField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.trackField, gridBagConstraints);
        jPanel.add(this.trackField);
        ++gridBagConstraints.gridy;
        this.artistField = new JTextField();
        this.artistField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.artistField, gridBagConstraints);
        jPanel.add(this.artistField);
        ++gridBagConstraints.gridy;
        this.albumField = new JTextField();
        this.albumField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.albumField, gridBagConstraints);
        jPanel.add(this.albumField);
        ++gridBagConstraints.gridy;
        this.genreField = new JTextField();
        this.genreField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.genreField, gridBagConstraints);
        jPanel.add(this.genreField);
        ++gridBagConstraints.gridy;
        this.yearField = new JTextField();
        this.yearField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.yearField, gridBagConstraints);
        jPanel.add(this.yearField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 4;
        this.pb1 = new JPanel(new GridLayout(4, 1, 4, 4)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 40;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 40;
                return dimension;
            }
        };
        this.artistBox = new JCheckBox();
        this.artistBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.artistField.setEnabled(true);
                TagEditor.this.artistField.grabFocus();
                TagEditor.this.artistField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.albumBox = new JCheckBox();
        this.albumBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.albumField.setEnabled(true);
                TagEditor.this.albumField.grabFocus();
                TagEditor.this.albumField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.genreBox = new JCheckBox();
        this.genreBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.genreField.setEnabled(true);
                TagEditor.this.genreField.grabFocus();
                TagEditor.this.genreField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.yearBox = new JCheckBox();
        this.yearBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.yearField.setEnabled(true);
                TagEditor.this.yearField.grabFocus();
                TagEditor.this.yearField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        gridBagLayout.setConstraints(this.pb1, gridBagConstraints);
        jPanel.add(this.pb1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.info1 = new JTextArea();
        this.info1.setLineWrap(true);
        this.info1.setWrapStyleWord(true);
        this.info1.setEditable(false);
        this.info1.setFont(jLabel.getFont());
        this.info1.setBackground(jLabel.getBackground());
        gridBagLayout.setConstraints(this.info1, gridBagConstraints);
        jPanel.add(this.info1);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagLayout = (GridBagLayout)jPanel2.getLayout();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jLabel = new JLabel(iComposer);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iLyricist);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iOrchestra);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iConductor);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        ++gridBagConstraints.gridy;
        jLabel = new JLabel(iPublisher);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.composerField = new JTextField();
        this.composerField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.composerField, gridBagConstraints);
        jPanel2.add(this.composerField);
        ++gridBagConstraints.gridy;
        this.lyricistField = new JTextField();
        this.lyricistField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.lyricistField, gridBagConstraints);
        jPanel2.add(this.lyricistField);
        ++gridBagConstraints.gridy;
        this.orchestraField = new JTextField();
        this.orchestraField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.orchestraField, gridBagConstraints);
        jPanel2.add(this.orchestraField);
        ++gridBagConstraints.gridy;
        this.conductorField = new JTextField();
        this.conductorField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.conductorField, gridBagConstraints);
        jPanel2.add(this.conductorField);
        ++gridBagConstraints.gridy;
        this.publisherField = new JTextField();
        this.publisherField.getDocument().addDocumentListener(documentListener);
        gridBagLayout.setConstraints(this.publisherField, gridBagConstraints);
        jPanel2.add(this.publisherField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 4;
        this.pb2 = new JPanel(new GridLayout(4, 1, 4, 4)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 40;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 40;
                return dimension;
            }
        };
        this.composerBox = new JCheckBox();
        this.composerBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.composerField.setEnabled(true);
                TagEditor.this.composerField.grabFocus();
                TagEditor.this.composerField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.lyricistBox = new JCheckBox();
        this.lyricistBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.lyricistField.setEnabled(true);
                TagEditor.this.lyricistField.grabFocus();
                TagEditor.this.lyricistField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.orchestraBox = new JCheckBox();
        this.orchestraBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.orchestraField.setEnabled(true);
                TagEditor.this.orchestraField.grabFocus();
                TagEditor.this.orchestraField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.conductorBox = new JCheckBox();
        this.conductorBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.conductorField.setEnabled(true);
                TagEditor.this.conductorField.grabFocus();
                TagEditor.this.conductorField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        this.publisherBox = new JCheckBox();
        this.publisherBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.publisherField.setEnabled(true);
                TagEditor.this.publisherField.grabFocus();
                TagEditor.this.publisherField.selectAll();
                TagEditor.this.apply.setEnabled(true);
            }
        });
        gridBagLayout.setConstraints(this.pb2, gridBagConstraints);
        jPanel2.add(this.pb2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.info2 = new JTextArea();
        this.info2.setLineWrap(true);
        this.info2.setWrapStyleWord(true);
        this.info2.setEditable(false);
        this.info2.setFont(jLabel.getFont());
        this.info2.setBackground(jLabel.getBackground());
        gridBagLayout.setConstraints(this.info2, gridBagConstraints);
        jPanel2.add(this.info2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.commentsField = new JTextArea();
        this.commentsField.getDocument().addDocumentListener(documentListener);
        jPanel3.add("Center", new JScrollPane(this.commentsField));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.lyricsField = new JTextArea();
        this.lyricsField.getDocument().addDocumentListener(documentListener);
        jPanel4.add("Center", new JScrollPane(this.lyricsField));
        this.tab.addTab(iTrackInfo, jPanel);
        this.tab.addTab(iExtraInfo, jPanel2);
        this.tab.addTab(iComments, jPanel3);
        this.tab.addTab(iLyrics, jPanel4);
        this.mainPanel.add("Center", this.tab);
        object2 = new JPanel();
        this.advanced = new JButton(iTEAdvanced);
        this.advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AutomaticTagsDialog(TagEditor.this.client, TagEditor.this, TagEditor.this.client.getViewEngine(), TagEditor.this.songs, 0);
            }
        });
        ((Container)object2).add(this.advanced);
        ((Container)object2).add(new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(100, 1);
            }
        });
        this.ok = new JButton(MusicClient.iOK);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TagEditor.this.apply.isEnabled()) {
                    TagEditor.this.apply();
                }
                TagEditor.this.setVisible(false);
            }
        });
        ((Container)object2).add(this.ok);
        this.cancel = new JButton(MusicClient.iCancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.setVisible(false);
            }
        });
        ((Container)object2).add(this.cancel);
        this.apply = new JButton(iApply);
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TagEditor.this.apply();
                TagEditor.this.apply.setEnabled(false);
            }
        });
        this.apply.setEnabled(this.toRefresh.size() > 0);
        ((Container)object2).add(this.apply);
        this.mainPanel.add("South", (Component)object2);
        if (this.tracksModel.size() > 0) {
            this.tracksList.setSelectionInterval(0, this.tracksModel.size() - 1);
        }
        this.getContentPane().add(this.mainPanel);
        this.pack();
        if (bl) {
            new Thread(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 21 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            new AutomaticTagsDialog(21.access$000(this.this$1).client, 21.access$000(this.this$1), 21.access$000(this.this$1).client.getViewEngine(), 21.access$000(this.this$1).songs, 0);
                        }
                    });
                }

                static /* synthetic */ TagEditor access$000(21 var0) {
                    return var0.TagEditor.this;
                }
            }.start();
        }
        this.setLocationRelativeTo(this.client);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Vector vector) {
        if (this.client.progress != null) {
            return;
        }
        this.finishedLoading = false;
        new Thread(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 23 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        23.access$100(this.this$1).client.progress = new SongLoadingProgress(23.access$100(this.this$1).client, iLoading, 0);
                        23.access$100(this.this$1).client.progress.internalTotal = 23.access$100(this.this$1).songs.size();
                        if (23.access$100(this.this$1).finishedLoading) {
                            23.access$100(this.this$1).client.progress.close();
                            23.access$100(this.this$1).client.progress = null;
                        } else {
                            23.access$100(this.this$1).client.progressInterrupted = false;
                            23.access$100(this.this$1).client.progress.setVisible(true);
                        }
                    }
                });
            }

            static /* synthetic */ TagEditor access$100(23 var0) {
                return var0.TagEditor.this;
            }
        }.start();
        try {
            Iterator iterator = null;
            iterator = vector == null ? this.songs.iterator() : vector.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                TagWriter tagWriter;
                Song song = (Song)iterator.next();
                this.file[n] = song.mp3();
                if (vector == null) {
                    this.tracksModel.addElement(this.file[n].getName());
                }
                if ((tagWriter = this.client.getTagWriter(this.file[n].getAbsolutePath(), false)) == null) {
                    this.readOnly[n] = true;
                } else {
                    int n2;
                    this.readOnly[n] = false;
                    this.title[n] = tagWriter.getName();
                    this.track[n] = tagWriter.getTrackString();
                    this.artist[n] = tagWriter.getArtist();
                    this.album[n] = tagWriter.getAlbum();
                    this.genre[n] = tagWriter.getGenre();
                    this.year[n] = tagWriter.getYearString();
                    this.composer[n] = tagWriter.getComposer();
                    this.lyricist[n] = tagWriter.getLyricist();
                    this.orchestra[n] = tagWriter.getOrchestra();
                    this.conductor[n] = tagWriter.getConductor();
                    this.publisher[n] = tagWriter.getPublisher();
                    this.comments[n] = tagWriter.getComments();
                    this.lyrics[n] = tagWriter.getLyrics();
                    this.client.deleteTagWriter(tagWriter);
                    if (this.client.progress != null) {
                        this.client.progress.update(iLoadingOf, n + 1, this.songs.size());
                    }
                    int n3 = 0;
                    if (this.track[n] != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < this.track[n].length() && Character.isDigit((char)(n2 = this.track[n].charAt(i))); ++i) {
                            stringBuffer.append((char)n2);
                        }
                        try {
                            n3 = Integer.parseInt(stringBuffer.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    int n4 = 0;
                    if (this.year[n] != null) {
                        char c;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (n2 = 0; n2 < this.year[n].length() && Character.isDigit(c = this.year[n].charAt(n2)); ++n2) {
                            stringBuffer.append(c);
                        }
                        try {
                            n4 = Integer.parseInt(stringBuffer.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((this.client.tagsDiffer(song, 3, this.title[n], song.name()) || this.client.tagsDiffer(song, 1, this.artist[n], song.artist() != null ? song.artist().name() : "") || this.client.tagsDiffer(song, 0, this.album[n], song.album() != null ? song.album().name() : "") || this.client.tagsDiffer(song, 8, this.genre[n], song.genre() != null ? song.genre().name() : "") || this.client.tagsDiffer(song, 14, this.composer[n], song.composer() != null ? song.composer().name() : "") || this.client.tagsDiffer(song, 17, this.lyricist[n], song.lyricist() != null ? song.lyricist().name() : "") || this.client.tagsDiffer(song, 16, this.orchestra[n], song.orchestra() != null ? song.orchestra().name() : "") || this.client.tagsDiffer(song, 15, this.conductor[n], song.conductor() != null ? song.conductor().name() : "") || this.client.tagsDiffer(song, 30, this.publisher[n], song.publisher() != null ? song.publisher() : "") || n3 != song.track() || n4 != song.year()) && !this.toRefresh.contains(this.songs)) {
                        this.toRefresh.add(song);
                    }
                }
                ++n;
            }
            this.finishedLoading = true;
        }
        catch (Throwable throwable) {
            this.finishedLoading = true;
            new Thread(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 25 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (25.access$200(this.this$1).client.progress != null) {
                                25.access$200(this.this$1).client.progress.close();
                                25.access$200(this.this$1).client.progress = null;
                            }
                        }
                    });
                }

                static /* synthetic */ TagEditor access$200(25 var0) {
                    return var0.TagEditor.this;
                }
            }.start();
            throw throwable;
        }
        new /* invalid duplicate definition of identical inner class */.start();
    }

    void refresh(Vector vector) {
        this.load(vector);
        int[] nArray = null;
        if (this.selection != null) {
            nArray = new int[this.selection.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.selection[i];
            }
            this.selection = null;
        }
        this.setSelection(nArray);
    }

    void setSelection(int[] nArray) {
        if (this.selection != null) {
            this.setValues();
        }
        this.selection = nArray;
        if (this.tab.getSelectedIndex() == 0) {
            this.pb1.invalidate();
        } else if (this.tab.getSelectedIndex() == 1) {
            this.pb2.invalidate();
        }
        this.pb1.removeAll();
        this.pb2.removeAll();
        if (nArray.length == 0) {
            this.info1.setText(iNoSelect);
            this.info2.setText(iNoSelect);
            this.titleField.setEnabled(false);
            this.trackField.setEnabled(false);
            this.artistField.setEnabled(false);
            this.albumField.setEnabled(false);
            this.genreField.setEnabled(false);
            this.yearField.setEnabled(false);
            this.composerField.setEnabled(false);
            this.lyricistField.setEnabled(false);
            this.orchestraField.setEnabled(false);
            this.conductorField.setEnabled(false);
            this.publisherField.setEnabled(false);
            this.commentsField.setEnabled(false);
            this.lyricsField.setEnabled(false);
            this.titleField.setText("");
            this.trackField.setText("");
            this.artistField.setText("");
            this.albumField.setText("");
            this.genreField.setText("");
            this.yearField.setText("");
            this.composerField.setText("");
            this.lyricistField.setText("");
            this.orchestraField.setText("");
            this.conductorField.setText("");
            this.publisherField.setText("");
            this.commentsField.setText("");
            this.lyricsField.setText("");
        } else if (nArray.length == 1) {
            this.info1.setText(MusicClient.STRINGS.expand("IDSTR_TE_PATH", new String[]{this.file[nArray[0]].getAbsolutePath()}));
            this.info2.setText(MusicClient.STRINGS.expand("IDSTR_TE_PATH", new String[]{this.file[nArray[0]].getAbsolutePath()}));
            this.titleField.setEnabled(true);
            this.trackField.setEnabled(true);
            this.artistField.setEnabled(true);
            this.albumField.setEnabled(true);
            this.genreField.setEnabled(true);
            this.yearField.setEnabled(true);
            this.composerField.setEnabled(true);
            this.lyricistField.setEnabled(true);
            this.orchestraField.setEnabled(true);
            this.conductorField.setEnabled(true);
            this.publisherField.setEnabled(true);
            this.commentsField.setEnabled(true);
            this.lyricsField.setEnabled(true);
            this.titleField.setText(this.title[nArray[0]]);
            this.trackField.setText(this.track[nArray[0]]);
            this.artistField.setText(this.artist[nArray[0]]);
            this.albumField.setText(this.album[nArray[0]]);
            this.genreField.setText(this.genre[nArray[0]]);
            this.yearField.setText(this.year[nArray[0]]);
            this.composerField.setText(this.composer[nArray[0]]);
            this.lyricistField.setText(this.lyricist[nArray[0]]);
            this.orchestraField.setText(this.orchestra[nArray[0]]);
            this.conductorField.setText(this.conductor[nArray[0]]);
            this.publisherField.setText(this.publisher[nArray[0]]);
            this.commentsField.setText(this.comments[nArray[0]]);
            this.lyricsField.setText(this.lyrics[nArray[0]]);
            this.titleField.setCaretPosition(0);
            this.trackField.setCaretPosition(0);
            this.artistField.setCaretPosition(0);
            this.albumField.setCaretPosition(0);
            this.genreField.setCaretPosition(0);
            this.yearField.setCaretPosition(0);
            this.composerField.setCaretPosition(0);
            this.lyricistField.setCaretPosition(0);
            this.orchestraField.setCaretPosition(0);
            this.conductorField.setCaretPosition(0);
            this.publisherField.setCaretPosition(0);
            this.commentsField.setCaretPosition(0);
            this.lyricsField.setCaretPosition(0);
        } else if (nArray.length > 1) {
            this.info1.setText(iMultiSelect);
            this.info2.setText(iMultiSelect);
            this.titleField.setEnabled(false);
            this.trackField.setEnabled(false);
            this.artistField.setEnabled(false);
            this.albumField.setEnabled(false);
            this.genreField.setEnabled(false);
            this.yearField.setEnabled(false);
            this.composerField.setEnabled(true);
            this.lyricistField.setEnabled(true);
            this.orchestraField.setEnabled(true);
            this.conductorField.setEnabled(true);
            this.publisherField.setEnabled(true);
            this.commentsField.setEnabled(true);
            this.lyricsField.setEnabled(true);
            this.pb1.add(this.artistBox);
            this.pb1.add(this.albumBox);
            this.pb1.add(this.genreBox);
            this.pb1.add(this.yearBox);
            this.pb2.add(this.composerBox);
            this.pb2.add(this.lyricistBox);
            this.pb2.add(this.orchestraBox);
            this.pb2.add(this.conductorBox);
            this.pb2.add(this.publisherBox);
        }
        if (this.tab.getSelectedIndex() == 0) {
            this.pb1.revalidate();
            this.pb1.repaint();
        } else if (this.tab.getSelectedIndex() == 1) {
            this.pb2.revalidate();
            this.pb2.repaint();
        }
    }

    void setValues() {
        if (this.selection == null || this.selection.length == 0) {
            return;
        }
        for (int i = 0; i < this.selection.length; ++i) {
            int n = this.selection[i];
            if (this.titleField.isEnabled()) {
                this.title[n] = this.titleField.getText();
            }
            if (this.trackField.isEnabled()) {
                this.track[n] = this.trackField.getText();
            }
            if (this.artistField.isEnabled()) {
                this.artist[n] = this.artistField.getText();
            }
            if (this.albumField.isEnabled()) {
                this.album[n] = this.albumField.getText();
            }
            if (this.genreField.isEnabled()) {
                this.genre[n] = this.genreField.getText();
            }
            if (this.yearField.isEnabled()) {
                this.year[n] = this.yearField.getText();
            }
            if (this.composerField.isEnabled()) {
                this.composer[n] = this.composerField.getText();
            }
            if (this.lyricistField.isEnabled()) {
                this.lyricist[n] = this.lyricistField.getText();
            }
            if (this.orchestraField.isEnabled()) {
                this.orchestra[n] = this.orchestraField.getText();
            }
            if (this.conductorField.isEnabled()) {
                this.conductor[n] = this.conductorField.getText();
            }
            if (this.publisherField.isEnabled()) {
                this.publisher[n] = this.publisherField.getText();
            }
            if (this.commentsField.isEnabled()) {
                this.comments[n] = this.commentsField.getText();
            }
            if (!this.lyricsField.isEnabled()) continue;
            this.lyrics[n] = this.lyricsField.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply() {
        Song song;
        int n;
        Song[] songArray;
        if (this.client.progress != null) {
            return;
        }
        Vector<Song> vector = new Vector<Song>();
        this.setValues();
        this.finishedApply = false;
        new Thread(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 27 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        27.access$300(this.this$1).client.progress = new SongLoadingProgress(27.access$300(this.this$1).client, iSaving, 0);
                        27.access$300(this.this$1).client.progress.internalTotal = 27.access$300(this.this$1).songs.size();
                        if (27.access$300(this.this$1).finishedApply) {
                            27.access$300(this.this$1).client.progress.close();
                            27.access$300(this.this$1).client.progress = null;
                        } else {
                            27.access$300(this.this$1).client.progressInterrupted = false;
                            27.access$300(this.this$1).client.progress.setVisible(true);
                        }
                    }
                });
            }

            static /* synthetic */ TagEditor access$300(27 var0) {
                return var0.TagEditor.this;
            }
        }.start();
        try {
            songArray = this.songs.iterator();
            n = 0;
            while (songArray.hasNext()) {
                song = (Song)songArray.next();
                this.file[n] = song.mp3();
                TagWriter tagWriter = this.client.getTagWriter(this.file[n].getAbsolutePath(), false);
                if (tagWriter != null && !this.readOnly[n]) {
                    boolean bl = false;
                    if (!StringUtil.equals(this.title[n], tagWriter.getName()) && tagWriter.setName(this.title[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.track[n], tagWriter.getTrackString()) && tagWriter.setTrack(this.track[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.artist[n], tagWriter.getArtist())) {
                        this.client.checkForArtistUpdate(tagWriter.getArtist(), this.artist[n]);
                        if (tagWriter.setArtist(this.artist[n])) {
                            bl = true;
                        }
                    }
                    if (!StringUtil.equals(this.album[n], tagWriter.getAlbum())) {
                        this.client.checkForAlbumUpdate(tagWriter.getAlbum(), this.album[n]);
                        if (tagWriter.setAlbum(this.album[n])) {
                            bl = true;
                        }
                    }
                    if (!StringUtil.equals(this.genre[n], tagWriter.getGenre())) {
                        this.client.checkForGenreUpdate(tagWriter.getGenre(), this.genre[n]);
                        if (tagWriter.setGenre(this.genre[n])) {
                            bl = true;
                        }
                    }
                    if (!StringUtil.equals(this.year[n], tagWriter.getYearString()) && tagWriter.setYear(this.year[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.composer[n], tagWriter.getComposer()) && tagWriter.setComposer(this.composer[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.lyricist[n], tagWriter.getLyricist()) && tagWriter.setLyricist(this.lyricist[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.orchestra[n], tagWriter.getOrchestra()) && tagWriter.setOrchestra(this.orchestra[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.conductor[n], tagWriter.getConductor()) && tagWriter.setConductor(this.conductor[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.publisher[n], tagWriter.getPublisher()) && tagWriter.setPublisher(this.publisher[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.comments[n], tagWriter.getComments()) && tagWriter.setComments(this.comments[n])) {
                        bl = true;
                    }
                    if (!StringUtil.equals(this.lyrics[n], tagWriter.getLyrics()) && tagWriter.setLyrics(this.lyrics[n])) {
                        bl = true;
                    }
                    if (bl) {
                        try {
                            song.setLocked(true);
                            if (tagWriter.saveChanges(this.client.isPreserveTimestamp())) {
                                if (!this.toRefresh.contains(song)) {
                                    this.toRefresh.add(song);
                                }
                            } else if (!vector.contains(song)) {
                                vector.add(song);
                            }
                        }
                        catch (Throwable throwable) {
                            App.logException(throwable);
                            if (!vector.contains(song)) {
                                vector.add(song);
                            }
                        }
                        finally {
                            song.setLocked(false);
                        }
                    }
                    this.client.deleteTagWriter(tagWriter);
                    if (this.client.progress != null) {
                        this.client.progress.update(iSavingOf, n + 1, this.songs.size());
                    }
                }
                ++n;
            }
            this.finishedApply = true;
        }
        catch (Throwable throwable) {
            this.finishedApply = true;
            new Thread(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 29 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (29.access$400(this.this$1).client.progress != null) {
                                29.access$400(this.this$1).client.progress.close();
                                29.access$400(this.this$1).client.progress = null;
                            }
                        }
                    });
                }

                static /* synthetic */ TagEditor access$400(29 var0) {
                    return var0.TagEditor.this;
                }
            }.start();
            throw throwable;
        }
        new /* invalid duplicate definition of identical inner class */.start();
        if (vector.size() > 0) {
            songArray = new StringBuffer();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                song = (Song)iterator.next();
                songArray.append(song.mp3().getAbsolutePath() + "\n");
            }
            this.client.showMessage(iTEErrorWriting + "\n" + songArray.toString());
        }
        if (this.toRefresh.size() > 0) {
            songArray = new Song[this.toRefresh.size()];
            for (n = 0; n < songArray.length; ++n) {
                songArray[n] = (Song)this.toRefresh.elementAt(n);
            }
            this.client.refresh(songArray);
        }
    }
}

