/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.util.Vector;
import music.cpp.client.Album;
import music.cpp.client.Artist;
import music.cpp.client.ByArtist;
import music.cpp.client.GenreInfo;
import music.cpp.client.ListGenerator;
import music.cpp.client.MusicClient;
import music.cpp.client.Song;

public class MusicState {
    ListGenerator tableSource;
    ByArtist albumSource;
    boolean hideSubcategories;
    Object[] selectedGenres;
    Object[] selectedArtists;
    Object[] selectedAlbums;
    boolean top40;
    boolean era;
    int[] values;
    Object librarySelection = null;
    int artistType = -1;

    MusicState(MusicClient musicClient) {
        this.tableSource = musicClient.tableSource;
        this.albumSource = musicClient.albumSource;
        this.hideSubcategories = musicClient.hideSubcategories;
        this.selectedGenres = musicClient.genreList.getSelectedValues();
        this.selectedArtists = musicClient.selectedArtists;
        this.selectedAlbums = musicClient.selectedAlbums;
        this.librarySelection = musicClient.getLibrarySelection();
        this.artistType = musicClient.getShowInArtistList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(MusicClient musicClient) {
        int n;
        musicClient.setShowInArtistList(this.artistType);
        if (this.hideSubcategories != musicClient.hideSubcategories) {
            musicClient.hideSubcategories = this.hideSubcategories;
            Vector vector = this.hideSubcategories ? musicClient.metaGenres : musicClient.rawGenres;
            musicClient.genres.removeAllElements();
            for (n = 0; n < vector.size(); ++n) {
                musicClient.genres.addElement(vector.elementAt(n));
            }
        }
        musicClient.suppressGenres = true;
        try {
            musicClient.genreList.clearSelection();
            if (this.selectedGenres != null) {
                for (int i = 0; i < this.selectedGenres.length; ++i) {
                    n = musicClient.genres.indexOf(this.selectedGenres[i]);
                    if (n < 0) continue;
                    musicClient.genreList.addSelectionInterval(n, n);
                }
            }
        }
        finally {
            musicClient.suppressGenres = false;
        }
        musicClient.selectedArtists = this.selectedArtists;
        musicClient.selectedAlbums = this.selectedAlbums;
        musicClient.albumSource = this.albumSource;
        musicClient.tableSource = this.tableSource;
        musicClient.setArtists();
        musicClient.resetLists();
        musicClient.setLibrarySelection(this.librarySelection);
    }

    void removeGenre(GenreInfo genreInfo) {
        if (this.albumSource != null) {
            this.albumSource.removeGenre(genreInfo);
        }
        if (this.tableSource != null) {
            this.tableSource.removeGenre(genreInfo);
        }
    }

    void removeSong(Song song) {
        if (this.albumSource != null) {
            this.albumSource.removeSong(song);
        }
        if (this.tableSource != null) {
            this.tableSource.removeSong(song);
        }
    }

    void removeArtist(Artist artist) {
        if (this.albumSource != null) {
            this.albumSource.removeArtist(artist);
        }
        if (this.tableSource != null) {
            this.tableSource.removeArtist(artist);
        }
    }

    void removeAlbum(Album album) {
        if (this.albumSource != null) {
            this.albumSource.removeAlbum(album);
        }
        if (this.tableSource != null) {
            this.tableSource.removeAlbum(album);
        }
    }
}

